# バッチ設計書 89-vscode-build.ps1

## 概要

本ドキュメントは、VSCodeビルドスクリプト `scripts/vscode-build.ps1` の設計仕様を定義するものです。このスクリプトは、Visual Studio Code開発環境からRoslynプロジェクトをビルドするために使用されます。

### 本バッチの処理概要

**業務上の目的・背景**：Roslynの開発者はVisual Studio以外にもVS Codeを使用してコードを編集することがあります。VS Codeからビルドを実行する際、標準のdotnet buildコマンドでは適切なビルド設定が適用されない場合があります。本スクリプトは、VS Code環境からRoslynプロジェクトを正しくビルドするための統一的なインターフェースを提供し、開発者体験を向上させます。

**バッチの実行タイミング**：VS Codeのタスク実行機能から呼び出されるか、開発者が手動でターミナルから実行します。

**主要な処理内容**：
1. ビルド対象ファイルパスの受け取り
2. ファイルからプロジェクトファイルの特定
3. ビルドツールの初期化
4. MSBuildまたはdotnet buildの実行
5. ビルド結果の出力

**前後の処理との関連**：`eng/build-utils.ps1`のユーティリティ関数に依存します。ビルド後はテスト実行（vscode-run-tests.ps1）に引き継ぐことができます。

**影響範囲**：ビルド対象プロジェクトの出力ディレクトリ（artifacts等）に影響します。

## バッチ種別

ビルド / 開発支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動/VS Codeタスク |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| .NET SDK | ビルドに必要な.NET SDKがインストールされていること |
| build-utils.ps1 | ユーティリティスクリプトが存在すること |
| C#/VBプロジェクト | 対象ファイルがC#またはVBプロジェクトに属すること |

### 実行可否判定

- 対象ファイルがC#/VBプロジェクトに属さない場合：エラー終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -filePath | string | Yes | - | ビルド対象のファイルパス |
| -msbuildEngine | string | No | "vs" | 使用するMSBuildエンジン |
| -framework | string | No | 空文字 | ターゲットフレームワーク |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースファイル | C#/VB | ビルド対象のソースファイル |
| プロジェクトファイル | .csproj/.vbproj | 自動検出されるプロジェクトファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/ | DLL/EXE | ビルド成果物 |
| 標準出力 | テキスト | ビルドログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 出力先 | プロジェクト設定に依存 |
| 形式 | コンパイル済みアセンブリ |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ StrictModeとErrorActionPreference設定
2. ユーティリティスクリプトロード
   └─ build-utils.ps1をドットソース
3. ファイル情報取得
   └─ Get-ItemPropertyでファイル情報取得
4. プロジェクト特定
   └─ Get-ProjectFileでプロジェクトファイル取得
5. ビルドツール初期化
   └─ InitializeBuildToolでビルドツール取得
6. ビルド引数構築
   └─ フレームワーク、オプション等を設定
7. ビルド実行
   └─ Exec-Commandでビルド実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[StrictMode設定]
    B --> C[build-utils.ps1ロード]
    C --> D[ファイル情報取得]
    D --> E[Get-ProjectFile]
    E --> F{プロジェクト発見?}
    F -->|No| G[エラーメッセージ出力]
    G --> H[exit 1]
    F -->|Yes| I[InitializeBuildTool]
    I --> J[ビルド引数構築]
    J --> K[Exec-Command実行]
    K --> L[exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | プロジェクト未検出 | ファイルがC#/VBプロジェクトに属さない | 正しいファイルを指定 |
| (MSBuild) | ビルドエラー | コンパイルエラー | ソースコードを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認
2. ソースファイルのパスが正しいか確認
3. プロジェクトファイルが存在するか確認
4. ビルドエラーの場合はソースコードを修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロジェクト |
| 目標処理時間 | プロジェクト規模に依存 |
| メモリ使用量上限 | MSBuildプロセスに依存 |

## 排他制御

同一プロジェクトへの並列ビルドは避けるべきです。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | プロジェクト未検出時 | "Failed to build project. {file} is not part of a C# / VB project." |
| ビルドログ | ビルド中 | MSBuild出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | VS Codeタスク |

## 備考

- MSBuildオプション：
  - `-v:m`：最小限の詳細出力
  - `-tl:off`：ターミナルログ無効
  - `-m`：マルチプロセッサビルド有効
  - `-p:RunAnalyzersDuringBuild=false`：アナライザ無効
  - `-p:GenerateFullPaths=true`：完全パス生成
- msbuildEngineは"vs"がデフォルト
- frameworkパラメータで特定のターゲットフレームワークを指定可能
- Set-StrictMode -version 3.0で厳格モードを有効化
