# バッチ設計書 9-eng/test-build-correctness.ps1

## 概要

本ドキュメントは、Roslynプロジェクトのビルド正確性検証テストスクリプト「eng/test-build-correctness.ps1」の設計仕様を記載する。

### 本バッチの処理概要

eng/test-build-correctness.ps1は、Roslynプロジェクトのビルド成果物が正確に生成されていることを検証するためのPowerShellスクリプトである。二重書き込み、プロジェクトファイル整合性、生成ファイル整合性など、ビルドの正確性に関する複数の検証を実行する。

**業務上の目的・背景**：コンパイラ開発において、ビルドの正確性は極めて重要である。本スクリプトは以下の品質保証を目的とする：
- ビルドプロセスが二重書き込み（同一ファイルへの複数回書き込み）を行っていないことの確認
- プロジェクトファイルの整合性（参照、依存関係等）の検証
- ソリューションの状態が一貫していることの確認
- 生成されたソースファイル（構文ファイル等）が最新であることの確認

**バッチの実行タイミング**：CI/CDパイプラインでの品質ゲートとして自動実行、プルリクエストのマージ前検証、リリースビルド前の最終確認。

**主要な処理内容**：
1. ブートストラップコンパイラのビルド（make-bootstrap.ps1使用）
2. ブートストラップコンパイラを使用したRoslynのフルビルド
3. BuildBossツールによるビルド成果物の検証
4. 生成されたコンパイラファイルの検証（generate-compiler-code.cs）
5. dotnet-formatによるコードフォーマット検証

**前後の処理との関連**：CI/CDパイプラインの品質検証フェーズで実行される。make-bootstrap.ps1、eng/build.ps1を内部で呼び出す。BuildBossツールを使用して検証を行う。

**影響範囲**：検証結果のみを出力し、ビルド成果物自体は変更しない。検証失敗時はCIパイプラインを停止させる。

## バッチ種別

テスト処理（ビルド正確性検証）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | CI/CDトリガーに応じて |
| 実行時刻 | 自動（イベント発生時） |
| 実行曜日 | 任意 |
| 実行日 | 任意 |
| トリガー | CI/CDパイプライン（PR検証、メインブランチビルド等） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows環境でのみ実行可能 |
| PowerShell | PowerShellが利用可能であること |
| .NET SDK | 必要な.NET SDKがインストールされていること |
| Git | リポジトリ情報取得のためgitが必要 |

### 実行可否判定

- -helpオプションで使用方法を表示して終了
- -bootstrapDirが未指定の場合は自動的にブートストラップビルドを実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -configuration | string | No | Debug | ビルド構成（Debug/Release） |
| -enableDumps | switch | No | false | クラッシュダンプ収集を有効化 |
| -bootstrapDir | string | No | "" | ブートストラップコンパイラのパス |
| -ci | switch | No | false | CI環境フラグ |
| -help | switch | No | false | ヘルプ表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Roslyn.slnx | Solution | 検証対象のソリューションファイル |
| ソースコード | C#/VB | コンパイル対象のソースファイル群 |
| eng/generate-compiler-code.cs | C# | コンパイラコード生成スクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 検証進捗・結果 |
| artifacts/log | binlog | ビルドログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | ビルドログ等 |
| 出力先 | artifacts/log |
| 文字コード | バイナリ/UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. 引数解析とヘルプ表示
   └─ -helpで使用方法表示
2. build-utils.ps1読み込み
   └─ 共通ユーティリティの読み込み
3. PR対象ブランチ取得
   └─ SYSTEM_PULLREQUEST_TARGETBRANCHから取得
4. クラッシュダンプ設定（-enableDumps時）
   └─ Windows Error Reportingの設定
5. ブートストラップビルド（-bootstrapDir未指定時）
   └─ make-bootstrap.ps1呼び出し
6. Roslynフルビルド
   └─ eng/build.ps1をブートストラップコンパイラで実行
7. BuildBoss検証
   └─ プロジェクト整合性、二重書き込み等を検証
8. 生成コンパイラファイル検証
   └─ generate-compiler-code.cs -test実行
9. フォーマット検証
   └─ dotnet-format whitespace検証
10. 正常終了
    └─ ExitWithExitCode 0
```

### フローチャート

```mermaid
flowchart TD
    A[test-build-correctness.ps1開始] --> B{-help?}
    B -->|Yes| C[使用方法表示]
    C --> D[終了]
    B -->|No| E[build-utils.ps1読み込み]
    E --> F{-enableDumps?}
    F -->|Yes| G[クラッシュダンプ設定]
    F -->|No| H{bootstrapDir指定?}
    G --> H
    H -->|No| I[make-bootstrap.ps1実行]
    H -->|Yes| J[eng/build.ps1実行]
    I --> J
    J --> K[一時ディレクトリ設定]
    K --> L[BuildBoss検証実行]
    L --> M[生成ファイル検証]
    M --> N[フォーマット検証]
    N --> O[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | ビルドエラー | コンパイルエラー | エラーメッセージに従い修正 |
| 1 | BuildBoss検証失敗 | プロジェクト整合性エラー | BuildBossの出力を確認し修正 |
| 1 | 生成ファイル不一致 | 生成ファイルが最新でない | eng/generate-compiler-code.cmdを実行 |
| 1 | フォーマットエラー | コードフォーマット違反 | dotnet format whitespaceを実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 自動リトライなし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

1. 終了コードを確認
2. 標準出力のエラーメッセージを確認
3. ブートストラップ失敗時はdocs/contributing/bootstrap-builds.mdを参照
4. エラー内容に応じてソースコードを修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイルシステム操作のみ） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ソリューション全体 |
| 目標処理時間 | 環境依存（通常30-60分） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

同一ディレクトリでの複数同時実行は不可。ビルド成果物に対する排他制御が必要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 常時 | 検証進捗 |
| バイナリログ | ビルド時 | MSBuild詳細ログ |
| Azure DevOpsログ | 失敗時 | ブートストラップ失敗調査ガイドへのリンク |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | Azure DevOps |

## 備考

- PR検証時はターゲットブランチのドキュメントを参照するよう動的に設定
- -enableDumpsオプションはレジストリを変更するため管理者権限が必要
- BuildBossはRoslynプロジェクト固有のビルド検証ツール
- 生成ファイル検証はC#/VBの構文定義ファイルを対象
- フォーマット検証は--verify-no-changesモードで差分がないことを確認
