# バッチ設計書 90-vscode-run-tests.ps1

## 概要

本ドキュメントは、VSCodeテスト実行スクリプト `scripts/vscode-run-tests.ps1` の設計仕様を定義するものです。このスクリプトは、Visual Studio Code開発環境からRoslynプロジェクトのテストを実行するために使用されます。

### 本バッチの処理概要

**業務上の目的・背景**：Roslynの開発者はコード変更後にテストを実行して品質を確認する必要があります。VS Code環境からテストを実行する際、標準のdotnet testコマンドでは適切なビルド設定やテスト結果の出力先が設定されない場合があります。本スクリプトは、VS Code環境からRoslynプロジェクトのテストを正しく実行し、結果をHTML形式で出力するための統一的なインターフェースを提供します。

**バッチの実行タイミング**：VS Codeのタスク実行機能から呼び出されるか、開発者が手動でターミナルから実行します。

**主要な処理内容**：
1. テスト対象ファイルパスの受け取り
2. ビルドの実行（vscode-build.ps1呼び出し）
3. ファイルからプロジェクトファイルの特定
4. .NET SDKの確保
5. テスト結果出力ディレクトリの準備
6. dotnet testの実行
7. テスト結果のHTML出力

**前後の処理との関連**：`vscode-build.ps1`でビルドを実行した後、`eng/build-utils.ps1`のユーティリティ関数を使用してテストを実行します。

**影響範囲**：artifacts/TestResultsディレクトリにテスト結果ファイルを出力します。

## バッチ種別

テスト実行 / 開発支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動/VS Codeタスク |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| .NET SDK | テスト実行に必要な.NET SDKがインストールされていること |
| build-utils.ps1 | ユーティリティスクリプトが存在すること |
| vscode-build.ps1 | ビルドスクリプトが存在すること |
| C#プロジェクト | 対象ファイルがC#プロジェクトに属すること |

### 実行可否判定

- 対象ファイルがC#プロジェクトに属さない場合：エラー終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -filePath | string | Yes | - | テスト対象のファイルパス |
| -msbuildEngine | string | No | "vs" | 使用するMSBuildエンジン |
| -framework | string | No | $null | ターゲットフレームワーク |
| -filter | string | No | 空文字 | テストフィルタ式 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| テストファイル | C# | テスト対象のソースファイル |
| プロジェクトファイル | .csproj | 自動検出されるプロジェクトファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/TestResults/ | HTML | テスト結果レポート |
| 標準出力 | テキスト | テスト実行ログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {LogFilePrefix}*.html |
| 出力先 | artifacts/TestResults/ |
| 文字コード | UTF-8 |
| 形式 | HTMLレポート |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ StrictModeとErrorActionPreference設定
2. ユーティリティスクリプトロード
   └─ build-utils.ps1をドットソース
3. ビルド実行
   └─ vscode-build.ps1を呼び出し
4. ファイル情報取得
   └─ Get-ItemPropertyでファイル情報取得
5. プロジェクト特定
   └─ Get-ProjectFileでプロジェクトファイル取得
6. .NET SDK確保
   └─ Ensure-DotNetSdkでSDKパス取得
7. 結果ディレクトリ準備
   └─ artifacts/TestResultsディレクトリ作成
8. 古い結果削除
   └─ 同一プレフィックスのHTMLファイル削除
9. dotnet test実行
   └─ HTMLロガーでテスト実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[StrictMode設定]
    B --> C[build-utils.ps1ロード]
    C --> D[vscode-build.ps1実行]
    D --> E[ファイル情報取得]
    E --> F[Get-ProjectFile]
    F --> G{プロジェクト発見?}
    G -->|No| H[エラーメッセージ出力]
    H --> I[exit 1]
    G -->|Yes| J[Ensure-DotNetSdk]
    J --> K[TestResultsディレクトリ作成]
    K --> L[古いHTMLファイル削除]
    L --> M[dotnet test実行]
    M --> N[exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | プロジェクト未検出 | ファイルがC#プロジェクトに属さない | 正しいファイルを指定 |
| (dotnet) | テスト失敗 | テストがパスしない | テストコードを修正 |
| (dotnet) | ビルド失敗 | コンパイルエラー | ソースコードを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認
2. ビルドが成功しているか確認
3. テストコードの問題を修正
4. フィルタ式が正しいか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1プロジェクト |
| 目標処理時間 | テスト数に依存 |
| メモリ使用量上限 | dotnetプロセスに依存 |

## 排他制御

同一プロジェクトへの並列テスト実行は避けるべきです。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 空行 | ビルド後 | 改行（区切り） |
| コマンド | テスト実行前 | "> $invocation"（実行コマンド） |
| エラーログ | プロジェクト未検出時 | "Failed to run tests. {file} is not part of a C# project." |
| テストログ | テスト中 | dotnet test出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 1 | VS Codeタスク |

## 備考

- dotnet testオプション：
  - `--logger "html;LogFilePrefix={prefix}"`：HTML形式でログ出力
  - `--results-directory {path}`：結果出力先
  - `--no-build`：ビルド済みのためスキップ
  - `--filter {expr}`：テストフィルタ（オプション）
  - `--framework {tfm}`：ターゲットフレームワーク（オプション）
- LogFilePrefixはfilter指定時はファイル名、なしの場合はプロジェクト名
- 古いテスト結果ファイルは同一プレフィックスのものを削除
- -ErrorAction SilentlyContinueで削除エラーを無視
- ビルドはvscode-build.ps1に委譲（--no-buildで再ビルド防止）
- Resolve-Pathで相対パスに変換して可読性向上
