# バッチ設計書 91-merge-vs-deps

## 概要

本ドキュメントは、scripts/merge-vs-deps.ps1スクリプトのバッチ設計書です。Visual Studio依存関係ブランチ（main-vs-deps）を現在のブランチにマージする処理を定義します。

### 本バッチの処理概要

このバッチはVisual Studio依存関係ブランチのマージ処理を自動化し、Roslynプロジェクトのブランチ同期を効率化します。

**業務上の目的・背景**：RoslynプロジェクトはVisual Studioと密接に連携しているため、VS依存関係の更新を定期的にメインブランチに取り込む必要があります。main-vs-depsブランチには、Visual Studioビルドに必要なバージョン情報やパッケージ依存関係の更新が含まれており、これらを適切にマージすることでビルドの互換性を維持します。手動マージは人為的ミスやマージ漏れのリスクがあるため、本バッチによる自動化が不可欠です。

**バッチの実行タイミング**：CIパイプラインの一部として実行、または手動でブランチ同期が必要な際に随時実行されます。

**主要な処理内容**：
1. Gitユーザー情報の設定（RoslynValidationユーザーとして）
2. アクセストークンの有無を判定
3. アクセストークンがない場合は通常のgit pullを実行
4. アクセストークンがある場合はBase64エンコードした認証ヘッダー付きでgit pullを実行
5. マージ失敗時はAzure DevOps警告ログを出力して正常終了

**前後の処理との関連**：本バッチは通常、ビルドパイプラインの初期段階で実行され、後続のビルド処理が最新のVS依存関係で実行されることを保証します。

**影響範囲**：現在のGitリポジトリのワーキングツリーに影響を与え、main-vs-depsブランチの変更がマージされます。

## バッチ種別

ソース同期 / ブランチマージ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIトリガーまたは手動） |
| 実行時刻 | CIパイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Gitリポジトリ | 現在のディレクトリがGitリポジトリであること |
| ネットワーク接続 | origin リモートへのアクセスが可能であること |
| ブランチ存在 | main-vs-depsブランチが存在すること |

### 実行可否判定

main-vs-depsブランチが存在しない場合、またはネットワーク問題がある場合は警告を出力して正常終了（exit 0）します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| accessToken | string | No | "" | Azure DevOpsまたはGitHub認証用のアクセストークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| origin/main-vs-deps | Gitブランチ | マージ元となるVS依存関係ブランチ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ワーキングツリー | Git | マージされたファイル群 |
| 標準出力 | テキスト | マージ結果またはエラーメッセージ |

### 出力ファイル仕様

本バッチはGitマージ操作のため、特定のファイル出力仕様はありません。

## 処理フロー

### 処理シーケンス

```
1. Gitユーザー情報設定
   └─ user.name: RoslynValidation
   └─ user.email: validation@roslyn.net
2. アクセストークン判定
   └─ 空文字列かどうかをチェック
3. git pull実行
   └─ トークンなし: 通常のgit pull origin main-vs-deps
   └─ トークンあり: Base64認証ヘッダー付きでgit pull
4. 結果判定
   └─ 成功: 正常終了
   └─ 失敗: Azure DevOps警告ログを出力して正常終了（exit 0）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Gitユーザー情報設定]
    B --> C{accessToken判定}
    C -->|空| D[通常のgit pull]
    C -->|値あり| E[認証付きgit pull]
    D --> F{pull成功?}
    E --> F
    F -->|成功| G[正常終了]
    F -->|失敗| H[Azure DevOps警告出力]
    H --> I[正常終了 exit 0]
    G --> J[バッチ終了]
    I --> J
```

## データベース操作仕様

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | マージ失敗 | main-vs-depsが存在しない、またはネットワーク問題 | 警告ログを出力して正常終了 |
| - | 認証失敗 | 無効なアクセストークン | 警告ログを出力して正常終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

マージ失敗時は警告を出力するのみで、後続処理は継続されます。手動でのマージが必要な場合は、開発者がローカルでgit pullを実行してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | Gitマージ操作単位 |
| コミットタイミング | git pullによる自動マージコミット |
| ロールバック条件 | コンフリクト発生時はマージ中断 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のマージ操作 |
| 目標処理時間 | 数秒〜数分（ネットワーク状況依存） |
| メモリ使用量上限 | Gitプロセス依存 |

## 排他制御

同一ワーキングツリーでの同時実行は推奨されません。CI環境では通常、ジョブ単位で排他制御されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | マージ失敗時 | ##vso[task.logissue type=warning]形式のAzure DevOps警告 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| マージ失敗 | 発生時 | Azure DevOpsログ |

## 備考

- マージコミットのユーザー情報は実際の変更に影響しないため、汎用的な値（RoslynValidation）が使用されています
- 本バッチはマージ失敗を致命的エラーとして扱わず、警告のみ出力して正常終了するため、CIパイプラインの中断を防ぎます
