# バッチ設計書 92-report-ci-times

## 概要

本ドキュメントは、scripts/report-ci-times.ps1スクリプトのバッチ設計書です。Azure DevOps CIパイプラインの実行時間データを収集・分析し、CSVレポートとして出力する処理を定義します。

### 本バッチの処理概要

このバッチはRoslyn CIパイプラインの各ジョブの実行時間を収集し、パフォーマンス分析用のCSVファイルを生成します。

**業務上の目的・背景**：CIパイプラインのパフォーマンス最適化は開発効率に直結する重要な課題です。ビルド時間やテスト実行時間の傾向を把握することで、ボトルネックの特定や改善施策の効果測定が可能になります。本バッチにより、Azure DevOps APIから取得したデータを構造化されたCSV形式で出力し、Excelなどでのグラフ化・分析を容易にします。

**バッチの実行タイミング**：手動実行。パフォーマンス分析が必要な際に随時実行されます。

**主要な処理内容**：
1. Azure DevOps REST APIを使用してRoslynパイプラインのビルド実行履歴を取得
2. 指定期間（minDate〜maxDate）の成功したビルドをフィルタリング
3. 各ビルドのタイムライン情報から個別ジョブの実行時間を抽出
4. ジョブ間の依存関係に基づいて待機時間を計算
5. 平均実行時間を算出してCSVファイルに出力

**前後の処理との関連**：出力されたCSVファイルはall-ci-times.xlsxにペーストしてグラフ化することを想定しています。

**影響範囲**：artifacts/ci-times.csvファイルを生成・上書きします。

## バッチ種別

レポート生成 / データ収集

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 必要時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ネットワーク接続 | Azure DevOps API (dev.azure.com) へのアクセスが可能であること |
| build-utils.ps1 | eng/build-utils.ps1が存在し、$ArtifactsDirが定義されていること |
| PowerShell | PowerShell実行環境 |

### 実行可否判定

Azure DevOps APIへのアクセスが可能であれば実行可能です。APIアクセスに失敗した場合はリトライ後にエラーとなります。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| - | - | - | - | スクリプト内定数で期間を指定 |

### スクリプト内定数

| 定数名 | 値 | 説明 |
|-------|-----|------|
| $roslynPipelineId | "15" | RoslynパイプラインのID |
| $minDate | 2022-07-20 | データ収集開始日 |
| $maxDate | 2022-08-03 | データ収集終了日 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Azure DevOps Pipelines API | REST API | パイプライン実行一覧 |
| Azure DevOps Builds API | REST API | ビルド詳細とタイムライン |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/ci-times.csv | CSV | ジョブ実行時間データ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | ci-times.csv |
| 出力先 | artifacts/ |
| 文字コード | UTF-8（PowerShell Export-Csv標準） |
| 区切り文字 | カンマ |

### 出力カラム（Jobクラス）

| カラム名 | 型 | 説明 |
|---------|-----|------|
| runId | int | パイプライン実行ID |
| attempt | int | 試行回数 |
| name | string | ジョブ名（優先度プレフィックス付き） |
| relativeStart | TimeSpan | 実行開始からの相対時間 |
| prereqFinish | TimeSpan? | 前提ジョブの完了時間 |
| startDelay | TimeSpan? | 待機時間 |
| duration | TimeSpan | 実行時間 |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ build-utils.ps1の読み込み
2. パイプライン実行一覧取得
   └─ Azure DevOps Pipelines APIを呼び出し
3. 各実行のフィルタリング
   └─ 期間内、完了済み、成功のビルドのみ抽出
4. タイムライン取得
   └─ 各ビルドのジョブ詳細を取得
5. ジョブ情報抽出
   └─ wantedRecordsに含まれるジョブのみ処理
6. 前提ジョブ時間計算
   └─ 依存関係に基づき待機時間を算出
7. 平均時間計算
   └─ 各ジョブタイプの平均実行時間を算出
8. CSV出力
   └─ artifacts/ci-times.csvに書き出し
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[build-utils.ps1読み込み]
    B --> C[Pipelines API呼び出し]
    C --> D{次の実行あり?}
    D -->|あり| E{期間内?}
    E -->|Yes| F{完了かつ成功?}
    F -->|Yes| G[タイムライン取得]
    G --> H[ジョブ情報抽出]
    H --> D
    F -->|No| D
    E -->|No| D
    D -->|なし| I[前提ジョブ時間計算]
    I --> J[平均時間計算]
    J --> K[CSV出力]
    K --> L[バッチ終了]
```

## データベース操作仕様

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | API呼び出しエラー | ネットワーク問題またはAPI応答エラー | 5回までリトライ |
| - | 前提ジョブ不整合 | 開始時刻が前提ジョブ完了前 | 例外をスロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 5回 |
| リトライ間隔 | 5秒 |
| リトライ対象エラー | API呼び出しエラー全般 |

### 障害時対応

API呼び出しが5回連続で失敗した場合、スクリプトは継続しますが、該当データは欠損します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル出力単位 |
| コミットタイミング | Export-Csv完了時 |
| ロールバック条件 | なし（上書き出力） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 期間内の成功ビルド数（数十〜数百件） |
| 目標処理時間 | 数分〜数十分（API応答時間依存） |
| メモリ使用量上限 | ジョブリストサイズ依存 |

## 排他制御

同時実行の制限はありませんが、出力ファイルが上書きされるため、複数インスタンスの同時実行は推奨されません。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 各ビルド処理時 | "Measuring run {id} created at {date} - {url}" |
| エラーログ | API呼び出し失敗時 | "Error in request to {uri}" |
| 完了ログ | CSV出力完了時 | "Exported CSV to {path}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | 手動実行のため監視なし |

## 備考

- 収集対象ジョブは$wantedRecordsに定義された23種類のビルド・テストジョブ
- $prioritiesでジョブのソート順序を制御し、関連ジョブがグラフ上で近接するよう配慮
- $prerequisitesでジョブ間の依存関係を定義し、待機時間を算出
- 複数回試行があるビルドはスキップされる
- フィルタ条件はスクリプト内のコメントで切り替え可能（main CIのみ、特定PR等）
