# バッチ設計書 93-UploadPerfProject

## 概要

本ドキュメントは、scripts/UploadAzureZip/UploadPerfProject.ps1スクリプトのバッチ設計書です。パフォーマンステストプロジェクトをZip化してAzure Blob Storageにアップロードする処理を定義します。

### 本バッチの処理概要

このバッチは指定されたパフォーマンステストプロジェクトフォルダをZip圧縮し、Azure Blob Storageの専用コンテナにアップロードします。

**業務上の目的・背景**：Roslynのパフォーマンステストは複数の環境で実行される必要があり、テストプロジェクトを中央のストレージに配置することで、テスト実行環境からの一貫したアクセスを可能にします。Azure Blob Storageを使用することで、高い可用性と帯域幅を確保し、大規模なテストプロジェクトの配布を効率化します。

**バッチの実行タイミング**：パフォーマンステストプロジェクトの更新時に手動で実行されます。

**主要な処理内容**：
1. AzCopy.exeの存在確認
2. 対話式プロンプトでフォルダ名、バージョン、Azureキーを取得
3. 指定フォルダをZip形式で圧縮
4. AzCopyを使用してAzure Blob Storageにアップロード

**前後の処理との関連**：アップロードされたZipファイルは、パフォーマンステスト実行環境からダウンロードして使用されます。

**影響範囲**：Azure Blob Storage（roslyn-perfコンテナ）にファイルを追加します。

## バッチ種別

データ連携 / ファイルアップロード

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 必要時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| AzCopy.exe | Program Files (x86)\Microsoft SDKs\Azure\AzCopy\AzCopy.exeが存在すること |
| Azureキー | dotnetci.blob.core.windows.netへのアクセスキーを所有していること |
| ソースフォルダ | 圧縮対象のフォルダがカレントディレクトリに存在すること |

### 実行可否判定

AzCopy.exeが存在しない場合、ダウンロードURLを表示してエラー終了（exit 1）します。

## 入力仕様

### 入力パラメータ（対話式プロンプト）

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ZipName | string | Yes | - | 圧縮対象のフォルダ名 |
| Version | string | Yes | - | Zipファイルのバージョン番号 |
| AzureKey | string | Yes | - | Azure Blob Storageのアクセスキー |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ローカルフォルダ | ディレクトリ | 圧縮対象のパフォーマンステストプロジェクト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ローカルZipファイル | ZIP | 圧縮されたプロジェクトファイル |
| Azure Blob Storage | ZIP | アップロードされたZipファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {フォルダ名}.{バージョン}.zip |
| 出力先（ローカル） | カレントディレクトリ |
| 出力先（Azure） | https://dotnetci.blob.core.windows.net/roslyn-perf |
| 圧縮レベル | Fastest |

## 処理フロー

### 処理シーケンス

```
1. AzCopy存在確認
   └─ 存在しない場合はエラー終了
2. 対話式入力
   └─ フォルダ名、バージョン、Azureキーを取得
3. パス構築
   └─ Zipファイルパスを生成
4. Zip圧縮
   └─ System.IO.Compression.ZipFile.CreateFromDirectory使用
5. Azureアップロード
   └─ AzCopyでBlob Storageにアップロード
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{AzCopy存在確認}
    B -->|なし| C[ダウンロードURL表示]
    C --> D[exit 1]
    B -->|あり| E[フォルダ名入力]
    E --> F[バージョン入力]
    F --> G[Azureキー入力]
    G --> H[Zipパス構築]
    H --> I[フォルダをZip圧縮]
    I --> J[AzCopyでアップロード]
    J --> K[バッチ終了]
```

## データベース操作仕様

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | AzCopy未検出 | AzCopy.exeが存在しない | AzCopyをインストール |
| - | 圧縮エラー | ソースフォルダが存在しないまたはアクセス不可 | フォルダパスを確認 |
| - | アップロードエラー | ネットワーク問題または認証失敗 | 接続とキーを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

アップロード失敗時は手動でAzCopyコマンドを再実行するか、Azure Portal経由でアップロードしてください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルアップロード単位 |
| コミットタイミング | アップロード完了時 |
| ロールバック条件 | なし（Blob Storageへの追加のみ） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | ファイルサイズとネットワーク速度に依存 |
| メモリ使用量上限 | 圧縮対象フォルダサイズに依存 |

## 排他制御

同一バージョンのファイルをアップロードする場合、既存ファイルが上書きされる可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 圧縮開始時 | "Zipping {source} into {dest}" |
| 進捗ログ | アップロード開始時 | "Uploading {path}" |
| AzCopyログ | アップロード中 | AzCopy標準出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | 手動実行のため監視なし |

## 備考

- AzCopyはMicrosoft Azure Storage用のコマンドラインツール
- ダウンロードURL: http://aka.ms/downloadazcopy
- 圧縮レベルは"Fastest"で高速圧縮優先
- 対話式プロンプトのためバッチ自動化には向かない
