# バッチ設計書 94-CreateAndUploadNugetZip

## 概要

本ドキュメントは、scripts/UploadAzureZip/CreateAndUploadNugetZip.ps1スクリプトのバッチ設計書です。NuGetパッケージキャッシュをZip化してAzure Blob Storageにアップロードする処理を定義します。

### 本バッチの処理概要

このバッチはNuGetパッケージキャッシュを復元・圧縮し、Azure Blob Storageにアップロードすることで、CI環境でのNuGetリストア時間を短縮します。

**業務上の目的・背景**：大規模なプロジェクトでは、NuGetパッケージのリストアに相当な時間がかかります。事前にパッケージキャッシュをZip化してクラウドストレージに配置することで、新規ビルドエージェントや初回ビルド時のリストア時間を大幅に削減できます。これにより、CIパイプラインの全体的なビルド時間が短縮され、開発効率が向上します。

**バッチの実行タイミング**：NuGetパッケージの大幅な更新時や、新しいブランチ（Main/Future）向けのキャッシュ作成時に手動で実行されます。

**主要な処理内容**：
1. AzCopy.exeの存在確認
2. 対話式プロンプトでブランチ名、バージョン、Azureキーを取得
3. Restore.cmdを実行してNuGetキャッシュを最新化
4. ユーザーホームの.nugetフォルダをZip圧縮
5. AzCopyを使用してAzure Blob Storageにアップロード

**前後の処理との関連**：アップロードされたZipファイルは、CIビルドの初期段階でダウンロード・展開され、NuGetリストアを高速化します。

**影響範囲**：Azure Blob Storage（roslynコンテナ）にファイルを追加します。

## バッチ種別

データ連携 / ファイルアップロード

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | 必要時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| AzCopy.exe | Program Files (x86)\Microsoft SDKs\Azure\AzCopy\AzCopy.exeが存在すること |
| Azureキー | dotnetci.blob.core.windows.netへのアクセスキーを所有していること |
| Restore.cmd | プロジェクトルートにRestore.cmdが存在すること |

### 実行可否判定

AzCopy.exeが存在しない場合、ダウンロードURLを表示してエラー終了（exit 1）します。

## 入力仕様

### 入力パラメータ（対話式プロンプト）

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| Branch | string | Yes | - | ブランチ名（Main または Future） |
| Version | string | Yes | - | Zipファイルのバージョン番号 |
| AzureKey | string | Yes | - | Azure Blob Storageのアクセスキー |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| $HOME/.nuget | ディレクトリ | NuGetパッケージキャッシュフォルダ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ローカルZipファイル | ZIP | 圧縮されたNuGetキャッシュ |
| Azure Blob Storage | ZIP | アップロードされたZipファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名（Main） | nuget.{バージョン}.zip |
| ファイル名（Future） | nuget.future.{バージョン}.zip |
| 出力先（ローカル） | スクリプトディレクトリ |
| 出力先（Azure） | https://dotnetci.blob.core.windows.net/roslyn |
| 圧縮レベル | Fastest |

## 処理フロー

### 処理シーケンス

```
1. AzCopy存在確認
   └─ 存在しない場合はエラー終了
2. 対話式入力
   └─ ブランチ名、バージョン、Azureキーを取得
3. ファイル名決定
   └─ Futureブランチの場合は".future"サフィックスを追加
4. NuGetキャッシュクリア（コメントアウト）
   └─ 現在は実行されない
5. NuGetリストア実行
   └─ Restore.cmdを呼び出し
6. Zip圧縮
   └─ $HOME/.nugetをZip化
7. Azureアップロード
   └─ AzCopyでBlob Storageにアップロード
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{AzCopy存在確認}
    B -->|なし| C[ダウンロードURL表示]
    C --> D[exit 1]
    B -->|あり| E[ブランチ名入力]
    E --> F[バージョン入力]
    F --> G[Azureキー入力]
    G --> H{Future?}
    H -->|Yes| I[.futureサフィックス追加]
    H -->|No| J[通常ファイル名]
    I --> K[Restore.cmd実行]
    J --> K
    K --> L[$HOME/.nugetをZip圧縮]
    L --> M[AzCopyでアップロード]
    M --> N[バッチ終了]
```

## データベース操作仕様

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | AzCopy未検出 | AzCopy.exeが存在しない | AzCopyをインストール |
| - | リストアエラー | NuGetリストアが失敗 | ネットワークとパッケージソースを確認 |
| - | 圧縮エラー | .nugetフォルダが存在しないまたはアクセス不可 | フォルダ権限を確認 |
| - | アップロードエラー | ネットワーク問題または認証失敗 | 接続とキーを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

失敗時は各ステップを手動で実行するか、エラー原因を調査して再実行してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイルアップロード単位 |
| コミットタイミング | アップロード完了時 |
| ロールバック条件 | なし（Blob Storageへの追加のみ） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | 数分〜数十分（.nugetサイズとネットワーク速度に依存） |
| メモリ使用量上限 | .nugetフォルダサイズに依存 |

## 排他制御

同一バージョンのファイルをアップロードする場合、既存ファイルが上書きされる可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | キャッシュクリア時 | "Clearing nuget caches"（コメントアウト中） |
| 進捗ログ | リストア開始時 | "Restoring nuget to fill cache" |
| 進捗ログ | 圧縮開始時 | "Zipping $HOME/.nuget into {path}" |
| 進捗ログ | 圧縮完了時 | "Done" |
| 進捗ログ | アップロード開始時 | "Uploading {path}" |
| AzCopyログ | アップロード中 | AzCopy標準出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | 手動実行のため監視なし |

## 備考

- NuGetキャッシュクリア処理（nuget.exe locals all -clear）は現在コメントアウトされている
- Futureブランチはexperimental/preview機能向けの別キャッシュとして使用
- .nugetフォルダは通常数GB〜数十GBになるため、十分なディスク容量が必要
- 圧縮レベルは"Fastest"で速度優先、圧縮率は低め
- アップロード先コンテナ"roslyn"はroslyn-perfとは異なる汎用コンテナ
