# バッチ設計書 96-uninstall

## 概要

本ドキュメントは、src/Setup/PowerShell/uninstall.ps1スクリプトのバッチ設計書です。NuGetパッケージアンインストール時にRoslynアナライザをVisual Studioプロジェクトから削除する処理を定義します。

### 本バッチの処理概要

このバッチはNuGetパッケージマネージャーがパッケージをアンインストールする際に自動実行され、アナライザDLLをプロジェクトのアナライザ参照から削除します。

**業務上の目的・背景**：Roslynアナライザパッケージをアンインストールする際、対応するアナライザ参照をプロジェクトから適切に削除する必要があります。参照が残存すると、存在しないDLLへの参照エラーやビルド警告が発生します。本スクリプトはNuGetパッケージのuninstall.ps1フックとして動作し、install.ps1で追加したアナライザ参照のクリーンアップを行います。これにより、パッケージのアンインストールが完全に行われ、プロジェクトの整合性が維持されます。

**バッチの実行タイミング**：NuGetパッケージマネージャーによるパッケージアンインストール時に自動実行されます。

**主要な処理内容**：
1. プロジェクトがパッケージ依存関係解決をサポートするか確認（サポートする場合はスキップ）
2. パッケージのanalyzersフォルダ内の全DLLをプロジェクトから削除
3. 言語非依存アナライザ（ルートフォルダ）を削除
4. 言語固有アナライザ（cs/vbサブフォルダ）をプロジェクト言語に応じて削除

**前後の処理との関連**：NuGet Uninstall-Packageコマンドの一部として実行されます。インストール時にはinstall.ps1が実行されます。

**影響範囲**：対象プロジェクトのアナライザ参照コレクションからDLLが削除されます。

## バッチ種別

セットアップ / プロジェクト構成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | NuGetパッケージアンインストール時 |
| 実行時刻 | 該当なし |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | NuGet Uninstall-Packageイベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Visual Studio | Visual Studioがインストールされていること |
| プロジェクト | 対象プロジェクトがアナライザ参照をサポートすること |
| インストール済み | 対象パッケージがinstall.ps1で登録されていること |

### 実行可否判定

プロジェクトがSupportsPackageDependencyResolution()をサポートする場合、このスクリプトは処理をスキップし、プロジェクトシステムにアナライザ削除を委譲します。

## 入力仕様

### 入力パラメータ（NuGetから渡される）

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| installPath | string | Yes | - | パッケージのインストールパス |
| toolsPath | string | Yes | - | パッケージのtoolsフォルダパス |
| package | object | Yes | - | パッケージ情報オブジェクト |
| project | object | Yes | - | 対象プロジェクトオブジェクト（EnvDTE.Project） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| analyzersフォルダ | DLLファイル | 削除対象の言語非依存アナライザ |
| analyzers/csフォルダ | DLLファイル | 削除対象のC#固有アナライザ |
| analyzers/vbフォルダ | DLLファイル | 削除対象のVB.NET固有アナライザ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| プロジェクトアナライザ参照 | 参照オブジェクト | 削除されたアナライザ参照 |

### 出力ファイル仕様

本バッチはファイル出力を行わず、プロジェクトオブジェクトのアナライザ参照コレクションを更新します。

## 処理フロー

### 処理シーケンス

```
1. パッケージ依存関係解決サポート確認
   └─ SupportsPackageDependencyResolution()がtrueならスキップ
2. analyzersパス構築
   └─ toolsPathの親フォルダからanalyzersフォルダを特定
3. 言語非依存アナライザ削除
   └─ analyzersフォルダ直下のDLLを削除（*.resources.dll除外）
4. 言語判定
   └─ $project.Typeからcs/vbを判定
5. 言語固有アナライザ削除
   └─ analyzers/{lang}フォルダのDLLを削除（try-catchで例外を無視）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{依存関係解決サポート?}
    B -->|Yes| C[処理終了 - プロジェクトシステムに委譲]
    B -->|No| D[analyzersパス構築]
    D --> E[言語非依存DLL取得]
    E --> F{アナライザ参照サポート?}
    F -->|Yes| G[言語非依存DLL削除]
    F -->|No| H[スキップ]
    G --> I[プロジェクト言語判定]
    H --> I
    I --> J{C# or VB.NET?}
    J -->|C#| K[csフォルダ設定]
    J -->|VB.NET| L[vbフォルダ設定]
    J -->|その他| M[処理終了]
    K --> N[言語固有DLL削除 try-catch]
    L --> N
    N --> O[バッチ終了]
```

## データベース操作仕様

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | フォルダ不在 | analyzersフォルダが存在しない | 正常終了（処理スキップ） |
| - | プロジェクト非対応 | AnalyzerReferencesプロパティがない | 正常終了（処理スキップ） |
| - | 削除失敗 | 参照が既に存在しない | try-catchで例外を無視して継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

削除に失敗した場合は、Visual Studioのプロジェクト設定から手動でアナライザ参照を削除してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | NuGetアンインストール操作全体 |
| コミットタイミング | アンインストール完了時 |
| ロールバック条件 | NuGetアンインストールがキャンセルまたは失敗した場合 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1パッケージあたり数個〜数十個のDLL |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

Visual Studioプロジェクトシステムによる排他制御に依存します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| - | - | 標準的なログ出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | NuGetパッケージマネージャーのログに依存 |

## 備考

- install.ps1と対になるスクリプト
- 言語固有アナライザの削除時のみtry-catchで例外を無視
- 言語非依存アナライザの削除時は例外処理なし（install.ps1と同様）
- 参照が存在しない状態でRemoveを呼ぶと例外が発生する可能性があるためtry-catchが追加されている
- *.resources.dllはリソースアセンブリのため削除対象外
