# バッチ設計書 97-RoslynAnalyzers-install

## 概要

本ドキュメントは、src/RoslynAnalyzers/assets/install.ps1スクリプトのバッチ設計書です。Roslynアナライザパッケージのインストール時にアナライザDLLをVisual Studioプロジェクトに登録する処理を定義します。

### 本バッチの処理概要

このバッチはRoslynアナライザNuGetパッケージのインストール時に実行され、アナライザDLLをプロジェクトのアナライザ参照として追加します。

**業務上の目的・背景**：Roslynアナライザはコード品質の向上に不可欠なツールであり、プロジェクト固有のコーディング規約やベストプラクティスの自動検証を可能にします。本スクリプトはNuGetパッケージのassetsフォルダに配置され、パッケージインストール時にアナライザを自動的にプロジェクトに統合します。src/Setup/PowerShell/install.ps1と同様の機能を持ちますが、RoslynAnalyzers固有のパッケージ構造に対応した実装となっています。

**バッチの実行タイミング**：NuGetパッケージマネージャーによるRoslynアナライザパッケージインストール時に自動実行されます。

**主要な処理内容**：
1. analyzersディレクトリの存在確認
2. 言語非依存アナライザ（ルートフォルダ）のDLLを登録
3. プロジェクト言語（C#/VB.NET）を判定
4. 言語固有アナライザ（cs/vbサブフォルダ）のDLLを登録

**前後の処理との関連**：NuGet Install-Packageコマンドの一部として実行されます。アンインストール時にはuninstall.ps1が実行されます。

**影響範囲**：対象プロジェクトのアナライザ参照コレクションにDLLが追加されます。

## バッチ種別

セットアップ / プロジェクト構成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | NuGetパッケージインストール時 |
| 実行時刻 | 該当なし |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | NuGet Install-Packageイベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Visual Studio | Visual Studioがインストールされていること |
| プロジェクト | 対象プロジェクトがアナライザ参照をサポートすること |
| パッケージ構造 | analyzersフォルダにDLLが配置されていること |

### 実行可否判定

analyzersディレクトリが存在しない場合、処理をスキップして正常終了します。

## 入力仕様

### 入力パラメータ（NuGetから渡される）

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| installPath | string | Yes | - | パッケージのインストールパス |
| toolsPath | string | Yes | - | パッケージのtoolsフォルダパス |
| package | object | Yes | - | パッケージ情報オブジェクト |
| project | object | Yes | - | 対象プロジェクトオブジェクト（EnvDTE.Project） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| analyzersフォルダ | DLLファイル | 言語非依存アナライザ |
| analyzers/csフォルダ | DLLファイル | C#固有アナライザ |
| analyzers/vbフォルダ | DLLファイル | VB.NET固有アナライザ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| プロジェクトアナライザ参照 | 参照オブジェクト | 追加されたアナライザ参照 |

### 出力ファイル仕様

本バッチはファイル出力を行わず、プロジェクトオブジェクトのアナライザ参照コレクションを更新します。

## 処理フロー

### 処理シーケンス

```
1. analyzersディレクトリ確認
   └─ 存在しない場合は処理終了
2. analyzersパス構築
   └─ toolsPathの親フォルダからanalyzersフォルダを特定
3. 言語非依存アナライザ登録
   └─ analyzersフォルダ直下の*.dllを登録
4. 言語判定
   └─ $project.Typeからcs/vbを判定
5. 言語固有アナライザ登録
   └─ analyzers/{lang}フォルダの*.dllを登録
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{analyzersディレクトリ存在?}
    B -->|No| C[処理終了]
    B -->|Yes| D[analyzersパス構築]
    D --> E[言語非依存DLL取得]
    E --> F{アナライザ参照サポート?}
    F -->|Yes| G[言語非依存DLL登録]
    F -->|No| H[スキップ]
    G --> I[プロジェクト言語判定]
    H --> I
    I --> J{C# or VB.NET?}
    J -->|C#| K[csフォルダ設定]
    J -->|VB.NET| L[vbフォルダ設定]
    J -->|その他| M[処理終了]
    K --> N[言語固有DLL登録]
    L --> N
    N --> O[バッチ終了]
```

## データベース操作仕様

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ディレクトリ不在 | analyzersディレクトリが存在しない | 正常終了（処理スキップ） |
| - | プロジェクト非対応 | AnalyzerReferencesプロパティがない | 正常終了（処理スキップ） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

登録に失敗した場合は、Visual Studioのプロジェクト設定から手動でアナライザ参照を追加してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | NuGetインストール操作全体 |
| コミットタイミング | インストール完了時 |
| ロールバック条件 | NuGetインストールがキャンセルまたは失敗した場合 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1パッケージあたり数個〜数十個のDLL |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

Visual Studioプロジェクトシステムによる排他制御に依存します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| - | - | 標準的なログ出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | NuGetパッケージマネージャーのログに依存 |

## 備考

- src/Setup/PowerShell/install.ps1との主な違い：
  - SupportsPackageDependencyResolution()チェックがない
  - *.resources.dll除外フィルタがない（-Filterオプションで*.dllのみ取得）
  - Get-ChildItemの引数形式が異なる（-Pathオプション vs 位置引数）
- パッケージ構造がassetsフォルダに配置される形式に対応
- 全てのDLLファイル（リソースDLL含む）が登録対象となる可能性がある
