# バッチ設計書 98-RoslynAnalyzers-uninstall

## 概要

本ドキュメントは、src/RoslynAnalyzers/assets/uninstall.ps1スクリプトのバッチ設計書です。Roslynアナライザパッケージのアンインストール時にアナライザDLLをVisual Studioプロジェクトから削除する処理を定義します。

### 本バッチの処理概要

このバッチはRoslynアナライザNuGetパッケージのアンインストール時に実行され、アナライザDLLをプロジェクトのアナライザ参照から削除します。

**業務上の目的・背景**：Roslynアナライザパッケージをアンインストールする際、対応するアナライザ参照をプロジェクトから適切に削除する必要があります。参照が残存すると、存在しないDLLへの参照エラーやビルド警告が発生します。本スクリプトはNuGetパッケージのassetsフォルダに配置され、install.ps1で追加したアナライザ参照のクリーンアップを行います。src/Setup/PowerShell/uninstall.ps1と同様の機能を持ちますが、RoslynAnalyzers固有のパッケージ構造に対応した実装となっています。

**バッチの実行タイミング**：NuGetパッケージマネージャーによるRoslynアナライザパッケージアンインストール時に自動実行されます。

**主要な処理内容**：
1. analyzersディレクトリの存在確認
2. 言語非依存アナライザ（ルートフォルダ）のDLLを削除
3. プロジェクト言語（C#/VB.NET）を判定
4. 言語固有アナライザ（cs/vbサブフォルダ）のDLLを削除（try-catchで例外を無視）

**前後の処理との関連**：NuGet Uninstall-Packageコマンドの一部として実行されます。インストール時にはinstall.ps1が実行されます。

**影響範囲**：対象プロジェクトのアナライザ参照コレクションからDLLが削除されます。

## バッチ種別

セットアップ / プロジェクト構成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | NuGetパッケージアンインストール時 |
| 実行時刻 | 該当なし |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | NuGet Uninstall-Packageイベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Visual Studio | Visual Studioがインストールされていること |
| プロジェクト | 対象プロジェクトがアナライザ参照をサポートすること |
| インストール済み | 対象パッケージがinstall.ps1で登録されていること |

### 実行可否判定

analyzersディレクトリが存在しない場合、処理をスキップして正常終了します。

## 入力仕様

### 入力パラメータ（NuGetから渡される）

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| installPath | string | Yes | - | パッケージのインストールパス |
| toolsPath | string | Yes | - | パッケージのtoolsフォルダパス |
| package | object | Yes | - | パッケージ情報オブジェクト |
| project | object | Yes | - | 対象プロジェクトオブジェクト（EnvDTE.Project） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| analyzersフォルダ | DLLファイル | 削除対象の言語非依存アナライザ |
| analyzers/csフォルダ | DLLファイル | 削除対象のC#固有アナライザ |
| analyzers/vbフォルダ | DLLファイル | 削除対象のVB.NET固有アナライザ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| プロジェクトアナライザ参照 | 参照オブジェクト | 削除されたアナライザ参照 |

### 出力ファイル仕様

本バッチはファイル出力を行わず、プロジェクトオブジェクトのアナライザ参照コレクションを更新します。

## 処理フロー

### 処理シーケンス

```
1. analyzersディレクトリ確認
   └─ 存在しない場合は処理終了
2. analyzersパス構築
   └─ toolsPathの親フォルダからanalyzersフォルダを特定
3. 言語非依存アナライザ削除
   └─ analyzersフォルダ直下の*.dllを削除
4. 言語判定
   └─ $project.Typeからcs/vbを判定
5. 言語固有アナライザ削除
   └─ analyzers/{lang}フォルダの*.dllを削除（try-catchで例外を無視）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{analyzersディレクトリ存在?}
    B -->|No| C[処理終了]
    B -->|Yes| D[analyzersパス構築]
    D --> E[言語非依存DLL取得]
    E --> F{アナライザ参照サポート?}
    F -->|Yes| G[言語非依存DLL削除]
    F -->|No| H[スキップ]
    G --> I[プロジェクト言語判定]
    H --> I
    I --> J{C# or VB.NET?}
    J -->|C#| K[csフォルダ設定]
    J -->|VB.NET| L[vbフォルダ設定]
    J -->|その他| M[処理終了]
    K --> N[言語固有DLL削除 try-catch]
    L --> N
    N --> O[バッチ終了]
```

## データベース操作仕様

本バッチはデータベース操作を行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ディレクトリ不在 | analyzersディレクトリが存在しない | 正常終了（処理スキップ） |
| - | プロジェクト非対応 | AnalyzerReferencesプロパティがない | 正常終了（処理スキップ） |
| - | 削除失敗 | 参照が既に存在しない | try-catchで例外を無視して継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

削除に失敗した場合は、Visual Studioのプロジェクト設定から手動でアナライザ参照を削除してください。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | NuGetアンインストール操作全体 |
| コミットタイミング | アンインストール完了時 |
| ロールバック条件 | NuGetアンインストールがキャンセルまたは失敗した場合 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1パッケージあたり数個〜数十個のDLL |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

Visual Studioプロジェクトシステムによる排他制御に依存します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| - | - | 標準的なログ出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | NuGetパッケージマネージャーのログに依存 |

## 備考

- install.ps1と対になるスクリプト
- 言語固有アナライザの削除時のみtry-catchで例外を無視
- 言語非依存アナライザの削除時は例外処理なし（install.ps1と同様）
- src/Setup/PowerShell/uninstall.ps1との主な違い：
  - analyzersディレクトリの存在確認がある
  - SupportsPackageDependencyResolution()チェックがない
  - *.resources.dll除外フィルタがない
- catchブロックは空で、例外発生時もログ出力なしで継続
