---
generated_at: 2026-02-10 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-Build.cmd バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Build.cmd` - ソースコード（2行）
- E-02: `eng/build.ps1` - メインビルドスクリプト（843行）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Build.cmdはPowerShellを起動しeng/build.ps1を呼び出す | E-01: `powershell -ExecutionPolicy ByPass -NoProfile -command "& """%~dp0eng\build.ps1""" -build %*"` | ○ |
| C-02 | -buildオプションがデフォルトで付与される | E-01: `-build %*` の記述 | ○ |
| C-03 | ExecutionPolicyがByPassに設定される | E-01: `-ExecutionPolicy ByPass` の記述 | ○ |
| C-04 | NoProfileオプションが使用される | E-01: `-NoProfile` の記述 | ○ |
| C-05 | コマンドライン引数がそのまま渡される | E-01: `%*` の記述 | ○ |
| C-06 | 本バッチはWindows環境向けである | E-01: `.cmd`拡張子、E-03: カテゴリ「ビルド」説明文 | ○ |
| C-07 | eng/build.ps1が実際のビルドロジックを担当 | E-02: 843行のPowerShellスクリプト、BuildSolution関数等 | ○ |
| C-08 | Roslyn.slnxがビルド対象ソリューション | E-02: `$solution = "Roslyn.slnx"` の定義 | ○ |
| C-09 | PowerShell 5以上が必要 | E-02: `if ($PSVersionTable.PSVersion.Major -lt "5")` のチェック | ○ |
| C-10 | artifacts配下に成果物が出力される | E-02: `$ArtifactsDir`変数の使用 | ○ |
| C-11 | バイナリログ出力に対応 | E-02: `-binaryLog`パラメータ、`/bl:`オプションの使用 | ○ |
| C-12 | 本バッチはビルドカテゴリに属する | E-03: No.1のカテゴリ「ビルド」 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] Build.cmdのソースコードと設計書の記述が一致しているか確認済み
- [x] eng/build.ps1との連携が正しく記述されているか確認済み
- [ ] 実際の実行環境での動作確認（任意）
