---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-eng/test-determinism.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/test-determinism.ps1` - ビルド決定論性テストスクリプト（316行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトconfigurationはDebug | E-01: `$configuration = "Debug"` (2行目) | ○ |
| C-02 | デフォルトmsbuildEngineはvs | E-01: `$msbuildEngine = "vs"` (3行目) | ○ |
| C-03 | デフォルトaltRootDriveはq: | E-01: `$altRootDrive = "q:"` (4行目) | ○ |
| C-04 | -helpでヘルプ表示 | E-01: `if ($help) { Print-Usage; exit 0 }` (20-22行目) | ○ |
| C-05 | スキップリストに特定のDLLが含まれる | E-01: `$script:skipList = @(...)` (27-41行目) | ○ |
| C-06 | Run-Build関数でMSBuildを実行 | E-01: `function Run-Build` (43-82行目) | ○ |
| C-07 | DebugDeterminism=trueを設定 | E-01: `/p:DebugDeterminism=true` (70行目) | ○ |
| C-08 | Features="debug-determinism"を設定 | E-01: `/p:Features="debug-determinism"` (71行目) | ○ |
| C-09 | DeterministicSourcePaths=trueを設定 | E-01: `/p:DeterministicSourcePaths=true` (76行目) | ○ |
| C-10 | MD5ハッシュを使用 | E-01: `(Get-FileHash $filePath -algorithm MD5).Hash` (108行目) | ○ |
| C-11 | Record-Binaries関数でハッシュを記録 | E-01: `function Record-Binaries` (136-148行目) | ○ |
| C-12 | 最低40個のバイナリを検証 | E-01: `if ($dataMap.Count -lt 40)` (157行目) | ○ |
| C-13 | 必須バイナリリストを検証 | E-01: `$list = @("Microsoft.CodeAnalysis.dll", ...)` (162-166行目) | ○ |
| C-14 | Test-Build関数で比較検証 | E-01: `function Test-Build` (183-251行目) | ○ |
| C-15 | 差分をZIPアーカイブに保存 | E-01: `[System.IO.Compression.ZipFile]::CreateFromDirectory` (243行目) | ○ |
| C-16 | substコマンドでドライブ割り当て | E-01: `Exec-Command "subst" "$altRootDrive $(Split-Path...)"` (266行目) | ○ |
| C-17 | subst /dでドライブ解除 | E-01: `Exec-Command "subst" "$altRootDrive /d"` (272行目) | ○ |
| C-18 | 本スクリプトはテストカテゴリに属する | E-02: No.10のカテゴリ「テスト」 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] 主要な入力パラメータがソースコードと一致するか確認済み
- [x] 処理フロー（3回ビルド、ハッシュ比較）が正しく記述されているか確認済み
- [x] スキップリストの内容が正しく記述されているか確認済み
- [x] subst使用によるパスマッピング検証が正しく記述されているか確認済み
- [ ] 実際の実行環境での動作確認（任意）
