---
generated_at: 2026-02-10 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：11-test-rebuild.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間**：具体的な数値根拠なし
  2. **メモリ使用量上限**：具体的な制限値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/test-rebuild.ps1` - メインスクリプトファイル（99行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: スクリプト内コメント「This script tests that Roslyn artifacts are rebuildable」
- E-04: パラメータ定義ブロック（行5-12）
- E-05: Print-Usage関数（行17-24）
- E-06: ブートストラップビルド処理（行35-39）
- E-07: BuildValidator実行処理（行44-85）
- E-08: 除外リスト定義（行48-78）
- E-09: エラーハンドリング処理（行89-94）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リビルド可能性テストを実行するスクリプトである | E-01, E-03 | ○ |
| C-02 | configurationパラメータのデフォルト値はDebug | E-04 | ○ |
| C-03 | ciパラメータのデフォルト値は$false | E-04 | ○ |
| C-04 | useGlobalNuGetCacheのデフォルト値は$true | E-04 | ○ |
| C-05 | -helpオプションでヘルプを表示して終了 | E-05 | ○ |
| C-06 | -bootstrapオプションでブートストラップビルドを実行 | E-06 | ○ |
| C-07 | BuildValidatorツールを使用して検証 | E-07 | ○ |
| C-08 | 除外リストに特定のアセンブリが含まれる | E-08 | ○ |
| C-09 | Semantic Search参照アセンブリは除外される | E-08 | ○ |
| C-10 | エラー時は例外とスタックトレースを出力 | E-09 | ○ |
| C-11 | 終了コード1でエラー終了する | E-09 | ○ |
| C-12 | artifacts/obj/を検証対象とする | E-07 | ○ |
| C-13 | artifacts/bin/を参照パスとして使用 | E-07 | ○ |
| C-14 | .NET SDK packsを参照パスとして使用 | E-07 | ○ |
| C-15 | artifacts/BuildValidator/にデバッグ情報を出力 | E-07 | ○ |
| C-16 | --verboseオプションで詳細ログを出力 | E-07 | ○ |
| C-17 | 目標処理時間は数分〜数十分 | **根拠なし** | △ |
| C-18 | メモリ使用量上限は特に制限なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な数値：スクリプト内に処理時間に関する定義なし
  - 候補：CI/CDログ / パフォーマンステスト結果 / 開発者ドキュメント
- メモリ使用量上限：スクリプト内にメモリ制限の定義なし
  - 候補：BuildValidatorツールのドキュメント / システム要件定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パラメータ定義と処理フローは明確に根拠あり
- 0: 低リスク - エラーハンドリングは実装済み
- 1: 中リスク - パフォーマンス要件は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] 除外リストの妥当性を確認（実際のビルド環境で差異が発生するか）
- [ ] ブートストラップビルドの必要性とタイミングを確認
- [ ] BuildValidatorツールの出力形式と解釈方法を確認
