---
generated_at: 2026-02-10 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：12-prepare-tests.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/prepare-tests.ps1` - メインスクリプトファイル（24行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: パラメータ定義（行1-2）
- E-04: testPayloadディレクトリ削除処理（行12）
- E-05: Ensure-DotNetSdk呼び出し（行13）
- E-06: PrepareTests.dll実行処理（行14）
- E-07: エラーハンドリング（行17-19）
- E-08: スクリプト内コメント「permissions issues make this a pain to do in PrepareTests itself」

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テスト準備スクリプトである | E-01, E-02 | ○ |
| C-02 | configurationパラメータのデフォルト値はDebug | E-03 | ○ |
| C-03 | testPayloadディレクトリを削除する | E-04 | ○ |
| C-04 | Ensure-DotNetSdkで.NET SDKを確保 | E-05 | ○ |
| C-05 | PrepareTests.dllをdotnet execで実行 | E-06 | ○ |
| C-06 | --sourceオプションでリポジトリルートを指定 | E-06 | ○ |
| C-07 | --destinationオプションでtestPayloadを指定 | E-06 | ○ |
| C-08 | --dotnetPathオプションでSDKパスを指定 | E-06 | ○ |
| C-09 | エラー時はexit 1で終了 | E-07 | ○ |
| C-10 | パーミッション問題でスクリプト内でディレクトリ削除 | E-08 | ○ |
| C-11 | net10.0ターゲットのPrepareTestsを使用 | E-06 | ○ |
| C-12 | artifacts/bin/PrepareTests/に依存 | E-06 | ○ |
| C-13 | artifacts/testPayload/に出力 | E-06 | ○ |
| C-14 | 目標処理時間は数分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な数値：スクリプト内に処理時間に関する定義なし
  - 候補：CI/CDログ / PrepareTestsツールのドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パラメータ定義と処理フローは明確に根拠あり
- 0: 低リスク - エラーハンドリングは実装済み
- 0: 低リスク - パーミッション問題への対処が明示的にコメントされている

## 6) レビュアーチェックリスト（最小）
- [ ] PrepareTestsツールのビルドが完了していることを確認
- [ ] testPayloadディレクトリの出力内容を確認
- [ ] configuration以外のパラメータが必要ないか確認
