---
generated_at: 2026-02-10 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：13-prepare-tests.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/prepare-tests.sh` - メインスクリプトファイル（31行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: set -u, set -e 設定（行6-9）
- E-04: シンボリックリンク解決処理（行14-21）
- E-05: tools.sh読み込み（行24）
- E-06: InitializeDotNetCli呼び出し（行26）
- E-07: testPayloadディレクトリ削除処理（行29）
- E-08: PrepareTests.dll実行処理（行31）
- E-09: スクリプト内コメント「permissions issues make this a pain to do in PrepareTests itself」

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Unix環境向けテスト準備スクリプトである | E-01, E-02 | ○ |
| C-02 | set -uで未定義変数エラーを有効化 | E-03 | ○ |
| C-03 | set -eでコマンド失敗時に終了 | E-03 | ○ |
| C-04 | シンボリックリンクを解決する処理がある | E-04 | ○ |
| C-05 | eng/common/tools.shを読み込む | E-05 | ○ |
| C-06 | InitializeDotNetCliで.NET CLIを初期化 | E-06 | ○ |
| C-07 | testPayloadディレクトリをrm -rfで削除 | E-07 | ○ |
| C-08 | PrepareTests.dllをdotnetコマンドで実行 | E-08 | ○ |
| C-09 | --unixオプションを付与して実行 | E-08 | ○ |
| C-10 | --sourceオプションでリポジトリルートを指定 | E-08 | ○ |
| C-11 | --destinationオプションでtestPayloadを指定 | E-08 | ○ |
| C-12 | --dotnetPathオプションでSDKパスを指定 | E-08 | ○ |
| C-13 | Debug構成固定で実行 | E-08 | ○ |
| C-14 | パーミッション問題でスクリプト内でディレクトリ削除 | E-09 | ○ |
| C-15 | 目標処理時間は数分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な数値：スクリプト内に処理時間に関する定義なし
  - 候補：CI/CDログ / PrepareTestsツールのドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シェルオプション設定と処理フローは明確に根拠あり
- 0: 低リスク - シンボリックリンク解決処理が実装済み
- 1: 中リスク - Debug構成固定のため、Release構成でのテストには別途対応が必要

## 6) レビュアーチェックリスト（最小）
- [ ] PrepareTestsツールのビルドが完了していることを確認
- [ ] Debug構成固定で問題ないか確認
- [ ] --unixオプションの動作を確認
