---
generated_at: 2026-02-10 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：16-Verify.cmd.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間**：具体的な数値根拠なし
  2. **メモリ使用量上限**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Verify.cmd` - メインスクリプトファイル（3行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: @echo off設定（行1）
- E-04: PowerShell呼び出し（行2）
- E-05: eng/build.ps1呼び出し（行2）
- E-06: -build -restore -rebuild -pack -test -runAnalyzers -warnAsErrorオプション（行2）
- E-07: %*パラメータパススルー（行2）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 完全なビルド検証スクリプトである | E-01, E-02 | ○ |
| C-02 | @echo offでエコーを抑制 | E-03 | ○ |
| C-03 | PowerShellを起動してbuild.ps1を呼び出す | E-04, E-05 | ○ |
| C-04 | -restoreオプションでパッケージリストア | E-06 | ○ |
| C-05 | -buildオプションでビルド実行 | E-06 | ○ |
| C-06 | -rebuildオプションでクリーンリビルド | E-06 | ○ |
| C-07 | -packオプションでパッケージ作成 | E-06 | ○ |
| C-08 | -testオプションでテスト実行 | E-06 | ○ |
| C-09 | -runAnalyzersオプションで静的解析 | E-06 | ○ |
| C-10 | -warnAsErrorオプションで警告をエラー化 | E-06 | ○ |
| C-11 | %*で追加引数をパススルー | E-07 | ○ |
| C-12 | Unix環境ではverify.shを使用 | E-02 | ○ |
| C-13 | eng/build.ps1への包括的なラッパー | E-01, E-05 | ○ |
| C-14 | 目標処理時間は30分〜1時間 | **根拠なし** | △ |
| C-15 | メモリ使用量上限は8GB以上推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な数値：環境依存のため定義困難
  - 候補：CI/CDログ / ベンチマーク結果
- メモリ使用量上限：システム要件定義が見つからない
  - 候補：eng/build.ps1 / README.md

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプト構造はシンプルで明確
- 0: 低リスク - 全オプションが明示的に指定されている
- 1: 中リスク - パフォーマンス要件は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] 全フェーズの実行順序が正しいか確認
- [ ] -warnAsErrorの影響範囲を確認
- [ ] 追加パラメータの使用例を確認
