---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：18-validate-code-formatting.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/validate-code-formatting.ps1` - メインスクリプトファイル（24行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: パラメータ定義（行1-5）
- E-04: build-utils.ps1読み込み（行10）
- E-05: Exec-DotNet呼び出し（行14）
- E-06: dotnet-formatコマンドオプション（行14）
- E-07: ExitWithExitCode呼び出し（行16, 19）
- E-08: エラーハンドリング（行17-20）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コードフォーマット検証スクリプトである | E-01, E-02 | ○ |
| C-02 | rootDirectoryパラメータを受け付ける | E-03 | ○ |
| C-03 | includeDirectoriesパラメータを受け付ける | E-03 | ○ |
| C-04 | ciパラメータを受け付ける（デフォルト$false） | E-03 | ○ |
| C-05 | build-utils.ps1を読み込む | E-04 | ○ |
| C-06 | dotnet-formatツールを実行する | E-05, E-06 | ○ |
| C-07 | -v detailedで詳細ログを出力 | E-06 | ○ |
| C-08 | whitespaceモードで実行 | E-06 | ○ |
| C-09 | --folderオプションでフォルダモード | E-06 | ○ |
| C-10 | --include-generatedで生成コードも含む | E-06 | ○ |
| C-11 | --includeで対象ディレクトリを指定 | E-06 | ○ |
| C-12 | --verify-no-changesで差異検出のみ | E-06 | ○ |
| C-13 | 成功時はExitWithExitCode 0 | E-07 | ○ |
| C-14 | 失敗時はExitWithExitCode 1 | E-07, E-08 | ○ |
| C-15 | 読み取り専用でファイルを変更しない | E-06 | ○ |
| C-16 | 目標処理時間は数分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な数値：スクリプト内に処理時間に関する定義なし
  - 候補：CI/CDログ / dotnet-formatベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パラメータ定義と処理フローは明確に根拠あり
- 0: 低リスク - dotnet-formatオプションが明示的
- 0: 低リスク - エラーハンドリングが実装済み

## 6) レビュアーチェックリスト（最小）
- [ ] rootDirectoryとincludeDirectoriesの指定方法を確認
- [ ] .editorconfigの設定内容を確認
- [ ] dotnet-formatツールのインストール状態を確認
