---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：19-validate-rules-missing-documentation.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/validate-rules-missing-documentation.ps1` - メインスクリプトファイル（27行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: パラメータ定義（行1-4）
- E-04: ログ出力（行9）
- E-05: build-utils.ps1読み込み（行11）
- E-06: プロジェクトファイルパス設定（行15）
- E-07: Exec-DotNet build呼び出し（行16）
- E-08: ビルドオプション（行16）
- E-09: エラーハンドリング（行18-23）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ルールドキュメント検証スクリプトである | E-01, E-02 | ○ |
| C-02 | ciパラメータを受け付ける（デフォルト$false） | E-03 | ○ |
| C-03 | 開始時にログを出力する | E-04 | ○ |
| C-04 | build-utils.ps1を読み込む | E-05 | ○ |
| C-05 | Microsoft.CodeAnalysis.Features.csprojを対象とする | E-06 | ○ |
| C-06 | dotnet buildを実行する | E-07 | ○ |
| C-07 | -t:GenerateRulesMissingDocumentationターゲットを指定 | E-08 | ○ |
| C-08 | -p:RoslynEnforceCodeStyle=falseを設定 | E-08 | ○ |
| C-09 | -p:RunAnalyzersDuringBuild=falseを設定 | E-08 | ○ |
| C-10 | -p:ContinuousIntegrationBuild=$ciを設定 | E-08 | ○ |
| C-11 | -c Releaseで構成を指定 | E-08 | ○ |
| C-12 | エラー時は例外とスタックトレースを出力 | E-09 | ○ |
| C-13 | 失敗時はExitWithExitCode 1 | E-09 | ○ |
| C-14 | Featuresプロジェクトのみをターゲット | E-06 | ○ |
| C-15 | Push-Locationで作業ディレクトリを変更 | E-05 | ○ |
| C-16 | Pop-Locationで元に戻る | E-09 | ○ |
| C-17 | 目標処理時間は数分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な数値：スクリプト内に処理時間に関する定義なし
  - 候補：CI/CDログ / ビルドベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - パラメータ定義と処理フローは明確に根拠あり
- 0: 低リスク - ビルドオプションが明示的に指定されている
- 0: 低リスク - エラーハンドリングが実装済み

## 6) レビュアーチェックリスト（最小）
- [ ] GenerateRulesMissingDocumentationターゲットの動作を確認
- [ ] 未文書化ルールの出力形式を確認
- [ ] プロジェクトファイルパスの正確性を確認
