---
generated_at: 2026-02-10 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：20-todo-check.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/todo-check.ps1` - メインスクリプトファイル（26行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義
- E-03: スクリプトコメント「Checks that TODO and PROTOTYPE comments are not present」（行1-3）
- E-04: Set-StrictMode設定（行6-7）
- E-05: 環境変数チェック（行8）
- E-06: PROTOTYPE検索処理（行9-16）
- E-07: TODO2検索処理（行18-24）
- E-08: Get-ChildItem除外設定（行10, 19）
- E-09: Select-String検索設定（行10, 19）
- E-10: throw文によるエラー処理（行14, 23）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TODOマーカー検証スクリプトである | E-01, E-02, E-03 | ○ |
| C-02 | Set-StrictModeを設定する | E-04 | ○ |
| C-03 | ErrorActionPreference=Stopを設定 | E-04 | ○ |
| C-04 | SYSTEM_PULLREQUEST_TARGETBRANCHを確認 | E-05 | ○ |
| C-05 | mainブランチへのマージ時にPROTOTYPE検索 | E-05, E-06 | ○ |
| C-06 | src, eng, scripts, docs/compilersを検索対象 | E-06, E-07 | ○ |
| C-07 | *.dll, *.exe, *.pdb, *.xlfを除外 | E-08 | ○ |
| C-08 | todo-check.ps1自体を除外 | E-08 | ○ |
| C-09 | PROTOTYPEパターンで検索 | E-09 | ○ |
| C-10 | CaseSensitiveで検索 | E-09 | ○ |
| C-11 | SimpleMatchで検索 | E-09 | ○ |
| C-12 | PROTOTYPE検出時に例外スロー | E-10 | ○ |
| C-13 | TODO2を常に検索 | E-07 | ○ |
| C-14 | TODO2検出時に例外スロー | E-10 | ○ |
| C-15 | 検出時にマーカー一覧を出力 | E-06, E-07 | ○ |
| C-16 | Select-Stringを使用 | E-09 | ○ |
| C-17 | Recurseで再帰検索 | E-08 | ○ |
| C-18 | 目標処理時間は数秒〜1分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な数値：スクリプト内に処理時間に関する定義なし
  - 候補：CI/CDログ / ファイルシステム検索ベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 検索パターンと除外設定が明確
- 0: 低リスク - 大文字小文字区別の検索が実装されている
- 0: 低リスク - Azure DevOps環境変数を適切に使用

## 6) レビュアーチェックリスト（最小）
- [ ] PROTOTYPEとTODO2の使い分けルールを確認
- [ ] 除外ファイルリストが適切か確認
- [ ] 環境変数SYSTEM_PULLREQUEST_TARGETBRANCHの設定を確認
