---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：21-publish-assets

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **PublishData設定ファイルのパス・形式**：コード内で参照される設定ファイルの詳細構造が未確認
  2. **想定処理件数**：実際のパッケージ数に関する根拠が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/publish-assets.ps1` ソースコード（行1-140）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` バッチ定義（行22）
- E-03: `eng/build-utils.ps1` 参照（スクリプト内でdot sourceされている）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | configurationパラメータは必須で空の場合エラー終了 | E-01 行121-124 | ○ |
| C-02 | nugetApiKeyパラメータでnuget.org用のAPIキーを指定 | E-01 行17, 26 | ○ |
| C-03 | testスイッチでテストモード実行（実際の公開を行わない） | E-01 行88-91 | ○ |
| C-04 | prValidationスイッチでvsフィードに公開 | E-01 行70-72 | ○ |
| C-05 | TLS 1.2がセキュリティプロトコルとして設定される | E-01 行21 | ○ |
| C-06 | .symbols.nupkgファイルはスキップされる | E-01 行52-55 | ○ |
| C-07 | arcadeフィード指定時はスキップされる | E-01 行74-78 | ○ |
| C-08 | Get-PublishKeyでホスト別にAPIキーを取得 | E-01 行23-31 | ○ |
| C-09 | Azure DevOpsへの公開ではAPIキーに"AzureArtifacts"を使用 | E-01 行28 | ○ |
| C-10 | nugetKindはShipping/NonShipping/PerBuildPreReleaseのみ許可 | E-01 行101-106 | ○ |
| C-11 | dotnet nuget pushでパッケージを公開 | E-01 行90 | ○ |
| C-12 | パッケージ単位で順次処理される | E-01 行43-92 | ○ |
| C-13 | エラー発生時は例外メッセージとスタックトレースを出力 | E-01 行135-138 | ○ |
| C-14 | build-utils.ps1をdot sourceで読み込む | E-01 行126 | ○ |
| C-15 | Ensure-DotnetSdkでSDKを確保 | E-01 行128 | ○ |
| C-16 | GetBranchPublishDataで公開設定を取得 | E-01 行130 | ○ |
| C-17 | PublishData設定ファイルのパス・形式 | **根拠なし** | △ |
| C-18 | 想定処理件数は数十〜数百パッケージ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PublishData関連の設定ファイル（FeedData.json、PackagesData.json等）の実際の形式と内容
  - 候補：`eng/PublishData/` ディレクトリ / `eng/build-utils.ps1` 内の関数定義
- 実際の公開パッケージ数の統計情報
  - 候補：CIログ / リリースノート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはソースコードから確認可能
- 1: 中リスク - 設定ファイルの詳細構造が未検証のため、実行時の設定エラーに注意

## 6) レビュアーチェックリスト（最小）
- [ ] PublishData関連ファイルの存在と形式を確認
- [ ] nuget.org、Azure DevOpsフィードへの実際の公開テストを実施
- [ ] エラー発生時のリカバリ手順が運用チームに共有されているか確認
