---
generated_at: 2026-02-10 14:34:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-generate-badges

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/generate-badges.ps1` ソースコード（行1-159）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` バッチ定義（行24）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 対象ブランチはmainとmain-vs-deps | E-01 行6-8 | ○ |
| C-02 | roslyn-CIのパイプラインIDは95 | E-01 行12 | ○ |
| C-03 | roslyn-integration-CIのパイプラインIDは96 | E-01 行12 | ○ |
| C-04 | Get-BuildsTableでBuildsテーブルを生成 | E-01 行31-49 | ○ |
| C-05 | Get-DesktopTableでDesktop Unit Testsテーブルを生成 | E-01 行51-70 | ○ |
| C-06 | Get-CoreClrTableでCoreClr Unit Testsテーブルを生成 | E-01 行72-91 | ○ |
| C-07 | Get-IntegrationTableでIntegration Testsテーブルを生成 | E-01 行93-114 | ○ |
| C-08 | Get-MiscTableでMisc Testsテーブルを生成 | E-01 行116-139 | ○ |
| C-09 | URLエンコードされたジョブ名を使用 | E-01 行13 | ○ |
| C-10 | 各テーブルをWrite-Outputで標準出力へ出力 | E-01 行145-149 | ○ |
| C-11 | 正常終了時は終了コード0 | E-01 行151 | ○ |
| C-12 | エラー時は例外メッセージとスタックトレースを出力 | E-01 行153-156 | ○ |
| C-13 | StrictModeとErrorActionPreferenceを設定 | E-01 行142-143 | ○ |
| C-14 | Buildsジョブ名はBuild_Windows_Debug/Release、Build_Unix_Debug | E-01 行32-36 | ○ |
| C-15 | MiscテストにはDeterminism、Analyzers等7種類のジョブが含まれる | E-01 行117-125 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主要な主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のテキスト生成スクリプトであり、システムへの副作用がない

## 6) レビュアーチェックリスト（最小）
- [ ] スクリプト内のジョブ名がAzure DevOpsの実際のジョブ名と一致しているか確認
- [ ] パイプラインID（95、96）が現在も有効であるか確認
- [ ] 新規追加されたブランチやジョブがある場合、スクリプトの更新を検討
