---
generated_at: 2026-02-10 14:36:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-cleanup_perf

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/cleanup_perf.ps1` ソースコード（行1-119）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` バッチ定義（行25）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CPCLocationパラメータのデフォルト値は"C:/CPC" | E-01 行2 | ○ |
| C-02 | ShouldArchiveパラメータはスイッチ型でデフォルトfalse | E-01 行3 | ○ |
| C-03 | Cpc.exe、msbuild.exe、csc.exe、vbc.exe、VBCSCompiler.exeを強制終了 | E-01 行20-24 | ○ |
| C-04 | taskkillコマンドで/Fオプションを使用 | E-01 行15 | ○ |
| C-05 | cpc.exe /Stop /SkipClean を実行 | E-01 行27 | ○ |
| C-06 | ToArchiveディレクトリが存在する場合は削除 | E-01 行31-33 | ○ |
| C-07 | ShouldArchive時にToArchiveディレクトリを作成 | E-01 行37 | ○ |
| C-08 | DataBackup*をToArchiveに移動 | E-01 行43 | ○ |
| C-09 | consumptionTempResults.xmlをToArchiveに移動 | E-01 行45 | ○ |
| C-10 | PerfLogsをToArchive/PerfLogsにコピー | E-01 行57-58 | ○ |
| C-11 | CPCディレクトリ削除失敗時にマシン再起動 | E-01 行79-80 | ○ |
| C-12 | マシン再起動は5秒後に実行 | E-01 行80 | ○ |
| C-13 | mlinfraswat@microsoft.comへの連絡を促すメッセージを表示 | E-01 行79 | ○ |
| C-14 | C:/CPCTracesディレクトリを削除 | E-01 行85-94 | ○ |
| C-15 | C:/PerfLogsディレクトリを削除 | E-01 行96-105 | ○ |
| C-16 | C:/PerfTempディレクトリを削除 | E-01 行107-116 | ○ |
| C-17 | 終了コード0は正常、1はエラー | E-01 行71, 118 | ○ |
| C-18 | StrictModeとErrorActionPreferenceを設定 | E-01 行6-8 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主要な主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - マシン再起動を伴う処理があるため、実行環境での確認が重要
- 1: 中リスク - 誤実行により実行中のビルド・コンパイルプロセスが終了する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] CPCツールのバージョンと互換性を確認
- [ ] 本番CI環境でのマシン再起動の影響範囲を確認
- [ ] 管理者権限が適切に付与されているか確認
