---
generated_at: 2026-02-10 14:38:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-crossgen

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/crossgen.sh` ソースコード（行1-53）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` バッチ定義（行26）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 入力パラメータ$1でRoslynアセンブリディレクトリを指定 | E-01 行11 | ○ |
| C-02 | unameでOS判定しRIDを決定 | E-01 行14-24 | ○ |
| C-03 | Darwin（macOS）ではRID=osx-x64 | E-01 行17-18 | ○ |
| C-04 | LinuxではRID=linux-x64 | E-01 行19-20 | ○ |
| C-05 | 未対応OSではエラー終了 | E-01 行21-23 | ○ |
| C-06 | Dependencies.propsからCoreCLRバージョンを取得 | E-01 行27-28 | ○ |
| C-07 | NuGetキャッシュからCrossGenツールを取得 | E-01 行30 | ○ |
| C-08 | CrossGenをBIN_DIRにコピー | E-01 行35 | ○ |
| C-09 | crossgenに実行権限を付与 | E-01 行36 | ○ |
| C-10 | mscorlib.dllにCrossGenを適用 | E-01 行38 | ○ |
| C-11 | System.Collections.Immutable.dllにCrossGenを適用 | E-01 行40 | ○ |
| C-12 | System.Reflection.Metadata.dllにCrossGenを適用 | E-01 行42 | ○ |
| C-13 | Microsoft.CodeAnalysis.dllにCrossGenを適用 | E-01 行44 | ○ |
| C-14 | Microsoft.CodeAnalysis.CSharp.dllにCrossGenを適用 | E-01 行46 | ○ |
| C-15 | Microsoft.CodeAnalysis.VisualBasic.dllにCrossGenを適用 | E-01 行48 | ○ |
| C-16 | csc.exe、vbc.exeにCrossGenを適用 | E-01 行50-52 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主要な主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - CrossGenは.NET 6以降で非推奨となっており、ReadyToRunへの移行を検討すべき
- 0: 低リスク - ファイル生成のみで副作用が限定的

## 6) レビュアーチェックリスト（最小）
- [ ] 現在使用している.NETバージョンでCrossGenが引き続きサポートされているか確認
- [ ] ReadyToRunへの移行が必要かどうか検討
- [ ] Dependencies.propsに記載されたCoreCLRバージョンが最新であるか確認
