---
generated_at: 2026-02-10 14:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：26-generate-compiler-code

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：実際の処理時間に関する実測データがない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/generate-compiler-code.cmd` ソースコード（行1-3）
- E-02: `eng/generate-compiler-code.cs` ソースコード（行1-241）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` バッチ定義（行27）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | dotnet runでgenerate-compiler-code.csを実行 | E-01 行2 | ○ |
| C-02 | --no-cacheオプションでキャッシュ無効化 | E-01 行2 | ○ |
| C-03 | -testオプションでテストモード実行 | E-02 行77-78 | ○ |
| C-04 | -configurationオプションでビルド構成指定 | E-02 行83-84 | ○ |
| C-05 | C#コンパイラのソースコードを生成 | E-02 行21-32 | ○ |
| C-06 | VBコンパイラのソースコードを生成 | E-02 行35-44 | ○ |
| C-07 | VB GetTextソースコードを生成 | E-02 行47-53 | ○ |
| C-08 | IOperationソースコードを生成 | E-02 行56-59 | ○ |
| C-09 | BoundTreeGeneratorを使用 | E-02 行6, 179-182 | ○ |
| C-10 | CSharpSyntaxGeneratorを使用 | E-02 行8, 31 | ○ |
| C-11 | CSharpErrorFactsGeneratorを使用 | E-02 行9, 32 | ○ |
| C-12 | VBSyntaxGeneratorを使用 | E-02 行10, 43 | ○ |
| C-13 | VBErrorFactsGeneratorを使用 | E-02 行11, 44 | ○ |
| C-14 | IOperationGeneratorを使用 | E-02 行7, 59 | ○ |
| C-15 | テストモードで生成結果と既存ファイルを比較 | E-02 行61-65, 189-217 | ○ |
| C-16 | 差分があればエラーメッセージを出力 | E-02 行204-208, 210-214 | ○ |
| C-17 | 進捗ログを出力 | E-02 行22, 35, 47, 56, 63, 67 | ○ |
| C-18 | 目標処理時間は数十秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 実際の処理時間に関するベンチマーク・実測データ
  - 候補：CIログ / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード生成のみで実行時の副作用が限定的

## 6) レビュアーチェックリスト（最小）
- [ ] 各ジェネレータプロジェクトがビルド可能であることを確認
- [ ] 生成されるファイル一覧が最新の状態と一致しているか確認
- [ ] CIでの-testモード実行が正常に動作しているか確認
