---
generated_at: 2026-02-10 14:42:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-evaluate-changed-paths

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/evaluate-changed-paths.sh` ソースコード（行1-168）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` バッチ定義（行28）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | --difftargetで差分比較対象を指定 | E-01 行53-55 | ○ |
| C-02 | --excludepathsで除外パスを指定（'+'区切り） | E-01 行57-60 | ○ |
| C-03 | --includepathsで含めるパスを指定（'+'区切り） | E-01 行61-64 | ○ |
| C-04 | --subsetでサブセット名を指定 | E-01 行65-68 | ○ |
| C-05 | --azurevariableで変数名を指定 | E-01 行69-72 | ○ |
| C-06 | pipeline-logging-functions.shを読み込む | E-01 行81 | ○ |
| C-07 | set -fでグロビング無効化 | E-01 行4 | ○ |
| C-08 | set -uで未定義変数アクセスをエラー | E-01 行7 | ○ |
| C-09 | set -eでコマンドエラー時に即座終了 | E-01 行11 | ○ |
| C-10 | git diffで-M、-C、-bオプションを使用 | E-01 行88 | ○ |
| C-11 | --exit-codeで差分判定 | E-01 行102 | ○ |
| C-12 | 除外パスは:!形式でフィルタ | E-01 行128 | ○ |
| C-13 | 含めるパスは:形式でフィルタ | E-01 行148 | ○ |
| C-14 | Write-PipelineSetVariableで変数設定 | E-01 行161 | ○ |
| C-15 | is_multi_job_variable=trueで複数ジョブ間共有 | E-01 行161 | ○ |
| C-16 | マッチした場合は変数をtrueに設定 | E-01 行161 | ○ |
| C-17 | マッチしない場合は"No changed files"を出力 | E-01 行164 | ○ |
| C-18 | --ignore-cr-at-eolと--ignore-space-at-eolオプションを使用 | E-01 行88 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主要な主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のパス評価スクリプトであり、システムへの副作用が変数設定のみ

## 6) レビュアーチェックリスト（最小）
- [ ] 指定されるパスパターンが意図した範囲をカバーしているか確認
- [ ] 設定された変数が後続ステップで正しく参照されているか確認
- [ ] パスフィルタの優先順位（除外が先、含めるが後）が意図通りか確認
