---
generated_at: 2026-02-10 14:44:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-mark-shipped

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/PublicApi/mark-shipped.ps1` ソースコード（行1-53）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` バッチ定義（行29）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | build-utils.ps1をdot sourceで読み込む | E-01 行37 | ○ |
| C-02 | RepoRootへPush-Locationで移動 | E-01 行38 | ○ |
| C-03 | Get-ChildItemでPublicApi.Shipped.txtを検索 | E-01 行40 | ○ |
| C-04 | 各ディレクトリでMarkShipped関数を呼び出す | E-01 行40-42 | ○ |
| C-05 | PublicAPI.Shipped.txtを読み込む | E-01 行8-9 | ○ |
| C-06 | PublicAPI.Unshipped.txtを読み込む | E-01 行14-15 | ○ |
| C-07 | *REMOVED*プレフィックスで削除APIを識別 | E-01 行17, 22-24 | ○ |
| C-08 | 通常エントリをshippedリストに追加 | E-01 行27 | ○ |
| C-09 | REMOVEDエントリをShippedから除外 | E-01 行32 | ○ |
| C-10 | Shipped.txtをソートして保存 | E-01 行32 | ○ |
| C-11 | Unshipped.txtを空にして保存 | E-01 行33 | ○ |
| C-12 | ASCIIエンコーディングで保存 | E-01 行32-33 | ○ |
| C-13 | 進捗ログでディレクトリパスを出力 | E-01 行18 | ○ |
| C-14 | StrictModeとErrorActionPreferenceを設定 | E-01 行4-5 | ○ |
| C-15 | 例外発生時にエラーメッセージを出力 | E-01 行45-47 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主要な主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 複数ファイルを一括更新するため、意図しない変更がないか確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 実行後にgit diffで変更内容を確認
- [ ] *REMOVED*エントリが正しくShipped.txtから削除されているか確認
- [ ] Unshipped.txtが空になっていることを確認
