---
generated_at: 2026-02-10 14:46:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-sort-unshipped

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/sort-unshipped.cmd` ソースコード（行1-3）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` バッチ定義（行30）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | src配下のPublicAPI.Unshipped.txtを検索 | E-01 行3（-Path src\） | ○ |
| C-02 | 再帰的にファイルを検索 | E-01 行3（-Recurse） | ○ |
| C-03 | PublicAPI.Unshipped.txtをフィルタ | E-01 行3（-Filter PublicAPI.Unshipped.txt） | ○ |
| C-04 | Get-Contentでファイル内容を読み込む | E-01 行3（Get-Content） | ○ |
| C-05 | Sort-Objectでソート | E-01 行3（Sort-Object） | ○ |
| C-06 | Set-Contentで上書き保存 | E-01 行3（Set-Content） | ○ |
| C-07 | ForEachで各ファイルを処理 | E-01 行3（ForEach） | ○ |
| C-08 | REMコメントで目的を説明 | E-01 行1 | ○ |
| C-09 | PowerShellを-Commandで呼び出す | E-01 行3（powershell -Command） | ○ |
| C-10 | ワンライナー形式のスクリプト | E-01 行3（1行で全処理） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主要な主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイルのソートのみで、内容の変更は行わない

## 6) レビュアーチェックリスト（最小）
- [ ] ソート後のファイルが意図通りの順序になっているか確認
- [ ] 空行や特殊文字を含む行が正しく処理されているか確認
