---
generated_at: 2026-02-10 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-eng/build.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/build.ps1` - メインビルドスクリプト（843行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | restore/build/sign/pack/test/publishの各フェーズを制御 | E-01: 1-16行目のコメント | ○ |
| C-02 | デフォルトconfigurationはDebug | E-01: `$configuration = "Debug"` (19行目) | ○ |
| C-03 | デフォルトmsbuildEngineはvs | E-01: `$msbuildEngine = "vs"` (21行目) | ○ |
| C-04 | PowerShell 5以上が必要 | E-01: `if ($PSVersionTable.PSVersion.Major -lt "5")` (751行目) | ○ |
| C-05 | -testVsiと-testDesktopは同時指定不可 | E-01: `if ($anyUnit -and $testVsi)` (192-195行目) | ○ |
| C-06 | -testVsiと-helixは同時指定不可 | E-01: `if ($testVsi -and $helix)` (197-200行目) | ○ |
| C-07 | ブートストラップビルドにmake-bootstrap.ps1を使用 | E-01: `& eng/make-bootstrap.ps1` (798行目) | ○ |
| C-08 | BuildSolution関数でMSBuildを実行 | E-01: `function BuildSolution()` (238-302行目) | ○ |
| C-09 | テスト実行にRunTests.dllを使用 | E-01: `$runTests = GetProjectOutputBinary "RunTests.dll"` (404行目) | ○ |
| C-10 | デフォルトソリューションはRoslyn.slnx | E-01: `$solution = "Roslyn.slnx"` (50行目) | ○ |
| C-11 | バイナリログはBuild.binlog | E-01: `$binaryLogName = "Build.binlog"` (184行目) | ○ |
| C-12 | CI環境でプレビューSDKを有効化 | E-01: `EnablePreviewSdks` (770行目) | ○ |
| C-13 | 統合テスト時にVSIXをデプロイ | E-01: `Deploy-VsixViaTool` (379行目) | ○ |
| C-14 | testDesktopのタイムアウトは90分 | E-01: `$args += " --timeout 90"` (418, 428行目) | ○ |
| C-15 | testVsiのタイムアウトは220分 | E-01: `$args += " --timeout 220"` (445行目) | ○ |
| C-16 | -launchでRoslynDev Hiveを起動 | E-01: `&$devenvExe /rootSuffix RoslynDev` (826行目) | ○ |
| C-17 | IBC最適化データの適用に対応 | E-01: `GetIbcDropName` 関数、`/p:EnableNgenOptimization` | ○ |
| C-18 | collectDumpsでProcDumpを使用 | E-01: `Ensure-ProcDump` 関数 (675-693行目) | ○ |
| C-19 | 公式ビルドオプションの検証 | E-01: `OfficialBuildOnly` 関数 (142-154行目) | ○ |
| C-20 | 本スクリプトはビルドカテゴリに属する | E-02: No.3のカテゴリ「ビルド」 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] 主要な入力パラメータがソースコードと一致するか確認済み
- [x] 処理フローがソースコードの実行順序と一致するか確認済み
- [x] エラー処理条件がソースコードと一致するか確認済み
- [ ] 実際の実行環境での動作確認（任意）
