---
generated_at: 2026-02-10 14:48:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-common-build

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/build.ps1` ソースコード（行1-179）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` バッチ定義（行31）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | -configurationパラメータのデフォルトはDebug | E-01 行3 | ○ |
| C-02 | -verbosityパラメータのデフォルトはminimal | E-01 行6 | ○ |
| C-03 | -warnAsErrorパラメータのデフォルトはtrue | E-01 行8 | ○ |
| C-04 | -nodeReuseパラメータのデフォルトはtrue | E-01 行9 | ○ |
| C-05 | Platform環境変数をクリアする | E-01 行38-41 | ○ |
| C-06 | tools.ps1を読み込む | E-01 行85 | ○ |
| C-07 | -clean時にartifactsディレクトリを削除 | E-01 行143-148 | ○ |
| C-08 | -helpオプションでヘルプを表示 | E-01 行151-154 | ○ |
| C-09 | -ci時にバイナリログを有効化 | E-01 行156-159 | ○ |
| C-10 | -ci時にnodeReuseを無効化 | E-01 行160 | ○ |
| C-11 | -nativeToolsOnMachine時に環境変数設定 | E-01 行163-165 | ○ |
| C-12 | -restore時にInitializeNativeToolsを呼び出す | E-01 行166-168 | ○ |
| C-13 | InitializeToolsetを呼び出す | E-01 行100 | ○ |
| C-14 | InitializeCustomToolsetを呼び出す | E-01 行101 | ○ |
| C-15 | restore-toolset.ps1があれば読み込む | E-01 行92-96 | ○ |
| C-16 | MSBuildにConfiguration等のプロパティを渡す | E-01 行119-139 | ○ |
| C-17 | -blオプションでbinlogパスを設定 | E-01 行103 | ○ |
| C-18 | -buildCheckオプションで/checkを設定 | E-01 行105 | ○ |
| C-19 | プロジェクトパスを絶対パスに解決 | E-01 行113 | ○ |
| C-20 | エラー時にスタックトレースを出力 | E-01 行173 | ○ |
| C-21 | Write-PipelineTelemetryErrorでテレメトリ出力 | E-01 行174 | ○ |
| C-22 | ExitWithExitCodeで終了コードを設定 | E-01 行175, 178 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主要な主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - dotnet/arcadeから提供される標準スクリプトであり、広くテストされている

## 6) レビュアーチェックリスト（最小）
- [ ] Arcade SDKのバージョンが最新であるか確認
- [ ] カスタムツールセット（restore-toolset.ps1）の変更がある場合は動作確認
- [ ] CI環境での動作確認（-ci オプション使用時の挙動）
