---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：31-eng_common_build.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/build.sh` - メインスクリプト本体（行1-278）
- E-02: `eng/common/tools.sh` - 依存ツールスクリプト（行1-600）
- E-03: `eng/common/cibuild.sh` - CIビルドラッパー（行1-17）
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set -u と set -e でシェルオプション設定 | E-01 行4,8 | ○ |
| C-02 | usage関数でヘルプメッセージ表示 | E-01 行10-50 | ○ |
| C-03 | --configuration オプションでビルド構成指定 | E-01 行105-107 | ○ |
| C-04 | --verbosity オプションで詳細度指定 | E-01 行109-111 | ○ |
| C-05 | --binaryLog オプションでバイナリログ有効化 | E-01 行113-115 | ○ |
| C-06 | --restore オプションでリストア実行 | E-01 行122-124 | ○ |
| C-07 | --build オプションでビルド実行 | E-01 行125-127 | ○ |
| C-08 | --test オプションでテスト実行 | E-01 行150-152 | ○ |
| C-09 | --sourceBuild でソースビルドモード有効化 | E-01 行134-140 | ○ |
| C-10 | --productBuild で製品ビルドモード有効化 | E-01 行141-146 | ○ |
| C-11 | source-build時はデフォルトでRelease構成 | E-01 行202-204 | ○ |
| C-12 | CI環境でpipelines_log、node_reuse、binary_log設定 | E-01 行206-212 | ○ |
| C-13 | tools.shを読み込み | E-01 行214 | ○ |
| C-14 | cleanフラグ時にartifactsディレクトリ削除 | E-01 行265-271 | ○ |
| C-15 | restore時にInitializeNativeTools呼び出し | E-01 行273-275 | ○ |
| C-16 | Build関数でInitializeToolset呼び出し | E-01 行225 | ○ |
| C-17 | MSBuild関数で各種プロパティ指定してビルド | E-01 行242-260 | ○ |
| C-18 | cibuild.shから呼び出される | E-03 行16 | ○ |
| C-19 | リトライ回数5回、指数バックオフ | E-02 行273-293 | ○ |
| C-20 | ExitWithExitCode 0で終了 | E-01 行262 | ○ |
| C-21 | --projects オプションでビルド対象指定 | E-01 行168-170 | ○ |
| C-22 | --ci オプションでCI環境フラグ設定 | E-01 行172-174 | ○ |
| C-23 | --prepareMachine オプションでマシン準備有効化 | E-01 行165-167 | ○ |
| C-24 | バイナリログはBuild.binlogとして出力 | E-01 行233-235 | ○ |
| C-25 | パフォーマンス要件はプロジェクト規模に依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値指標
  - 候補：実際のビルド時間測定データ / プロジェクト別ベンチマーク / CI実行履歴

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本スクリプトはdotnet/arcadeの標準スクリプトであり、十分にテストされている

## 6) レビュアーチェックリスト（最小）
- [ ] 入力パラメータの説明が実際のコードと一致しているか確認
- [ ] 処理フローがコードの実行順序と一致しているか確認
- [ ] エラーハンドリングの記述が網羅的か確認
