---
generated_at: 2026-02-10 14:31:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-eng_common_cibuild.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/cibuild.sh` - スクリプト本体（行1-17）
- E-02: `eng/common/build.sh` - 依存するビルドスクリプト
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BASH_SOURCE[0]からソースパス取得 | E-01 行3 | ○ |
| C-02 | シンボリックリンクの解決処理 | E-01 行6-13 | ○ |
| C-03 | readlinkでパス解決 | E-01 行8 | ○ |
| C-04 | dirnameでスクリプトルート取得 | E-01 行7,14 | ○ |
| C-05 | build.shを呼び出し | E-01 行16 | ○ |
| C-06 | --restore オプション指定 | E-01 行16 | ○ |
| C-07 | --build オプション指定 | E-01 行16 | ○ |
| C-08 | --test オプション指定 | E-01 行16 | ○ |
| C-09 | --pack --publish --ci オプション指定 | E-01 行16 | ○ |
| C-10 | 追加引数($@)のパススルー | E-01 行16 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 非常にシンプルなラッパースクリプトであり、ロジックが明確

## 6) レビュアーチェックリスト（最小）
- [ ] build.shへのオプションが正しく記載されているか確認
- [ ] シンボリックリンク解決ロジックの説明が正確か確認
