---
generated_at: 2026-02-10 14:32:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-eng_common_dotnet-install.ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/dotnet-install.ps1` - スクリプト本体（行1-29）
- E-02: `eng/common/tools.ps1` - 依存ツールスクリプト（InstallDotNet関数定義）
- E-03: `eng/common/dotnet-install.cmd` - cmdラッパー
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | -verbosityパラメータでデフォルトminimal | E-01 行3 | ○ |
| C-02 | -architectureパラメータで空がデフォルト | E-01 行4 | ○ |
| C-03 | -versionパラメータでLatestがデフォルト | E-01 行5 | ○ |
| C-04 | -runtimeパラメータでdotnetがデフォルト | E-01 行6 | ○ |
| C-05 | -RuntimeSourceFeed/-RuntimeSourceFeedKeyパラメータ | E-01 行7-8 | ○ |
| C-06 | tools.ps1を読み込み | E-01 行11 | ○ |
| C-07 | dotnetRootは$RepoRoot/.dotnet | E-01 行13 | ○ |
| C-08 | x86アーキテクチャ時は.dotnet/x86に変更 | E-01 行17-19 | ○ |
| C-09 | InstallDotNet関数を呼び出し | E-01 行20 | ○ |
| C-10 | エラー時にスタックトレース出力 | E-01 行23 | ○ |
| C-11 | エラー時にWrite-PipelineTelemetryError出力 | E-01 行24 | ○ |
| C-12 | エラー時にExitWithExitCode 1で終了 | E-01 行25 | ○ |
| C-13 | 正常時にExitWithExitCode 0で終了 | E-01 行28 | ○ |
| C-14 | リトライ回数5回・指数バックオフ | E-02 行230-252 | ○ |
| C-15 | 複数フィードから順次試行 | E-02 行326-364 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなラッパースクリプトで、主要ロジックはtools.ps1に委譲

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータのデフォルト値が正しく記載されているか確認
- [ ] InstallDotNet関数の引数が正しく渡されているか確認
- [ ] エラーハンドリングの記述が正確か確認
