---
generated_at: 2026-02-10 14:33:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-eng_common_dotnet-install.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/dotnet-install.sh` - スクリプト本体（行1-95）
- E-02: `eng/common/tools.sh` - 依存ツールスクリプト（InstallDotNet関数定義）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | シンボリックリンク解決処理 | E-01 行4-12 | ○ |
| C-02 | tools.shを読み込み | E-01 行14 | ○ |
| C-03 | -versionパラメータでLatestがデフォルト | E-01 行16 | ○ |
| C-04 | -architectureパラメータで空がデフォルト | E-01 行17 | ○ |
| C-05 | -runtimeパラメータでdotnetがデフォルト | E-01 行18 | ○ |
| C-06 | コマンドライン引数解析ループ | E-01 行21-50 | ○ |
| C-07 | uname -mでCPU検出 | E-01 行53 | ○ |
| C-08 | arm64/aarch64の検出とbuildarch=arm64設定 | E-01 行55-56 | ○ |
| C-09 | 32bit OS on 64bit CPU検出（getconf LONG_BIT） | E-01 行57-60 | ○ |
| C-10 | loongarch64の検出 | E-01 行62-63 | ○ |
| C-11 | amd64/x86_64の検出とbuildarch=x64設定 | E-01 行65-66 | ○ |
| C-12 | armv*lの検出とbuildarch=arm設定 | E-01 行68-69 | ○ |
| C-13 | i386/i686の検出とbuildarch=x86設定 | E-01 行71-72 | ○ |
| C-14 | riscv64の検出 | E-01 行74-75 | ○ |
| C-15 | 未知CPUはx64として扱い警告出力 | E-01 行77-80 | ○ |
| C-16 | dotnetRootの設定 | E-01 行83 | ○ |
| C-17 | アーキテクチャ違い時はサブディレクトリ使用 | E-01 行84-86 | ○ |
| C-18 | InstallDotNet関数を呼び出し | E-01 行88 | ○ |
| C-19 | エラー時にWrite-PipelineTelemetryError出力 | E-01 行90 | ○ |
| C-20 | 正常時にExitWithExitCode 0で終了 | E-01 行94 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - アーキテクチャ検出ロジックが明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] サポートアーキテクチャの一覧が正しいか確認
- [ ] uname出力とbuildarchのマッピングが正確か確認
- [ ] 32bit OS on 64bit CPU検出ロジックの説明が正確か確認
