---
generated_at: 2026-02-10 14:34:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-eng_common_dotnet-install.cmd

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/dotnet-install.cmd` - スクリプト本体（行1-2）
- E-02: `eng/common/dotnet-install.ps1` - 依存するPowerShellスクリプト
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | @echo offでコマンドエコー無効化 | E-01 行1 | ○ |
| C-02 | PowerShell起動 | E-01 行2 | ○ |
| C-03 | -ExecutionPolicy ByPassで実行ポリシー回避 | E-01 行2 | ○ |
| C-04 | -NoProfileでプロファイル読み込みスキップ | E-01 行2 | ○ |
| C-05 | -commandオプションでスクリプト実行 | E-01 行2 | ○ |
| C-06 | %~dp0で同一ディレクトリを指定 | E-01 行2 | ○ |
| C-07 | dotnet-install.ps1を呼び出し | E-01 行2 | ○ |
| C-08 | %*で全引数をパススルー | E-01 行2 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 2行のみの非常にシンプルなラッパースクリプト

## 6) レビュアーチェックリスト（最小）
- [ ] PowerShellオプションの説明が正確か確認
- [ ] パス指定（%~dp0）の説明が正確か確認
