---
generated_at: 2026-02-10 14:35:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-eng_common_tools.ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/tools.ps1` - スクリプト本体（行1-961）
- E-02: `eng/common/pipeline-logging-functions.ps1` - パイプラインログ関数
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | $ciのデフォルトはfalse | E-01 行5 | ○ |
| C-02 | $configurationのデフォルトはDebug | E-01 行8 | ○ |
| C-03 | $binaryLogはCI時true | E-01 行14 | ○ |
| C-04 | $pipelinesLogはCI時true | E-01 行20 | ○ |
| C-05 | $nodeReuseは!$ci | E-01 行32 | ○ |
| C-06 | $warnAsErrorのデフォルトはtrue | E-01 行35 | ○ |
| C-07 | Set-StrictMode -Version 2.0設定 | E-01 行59 | ○ |
| C-08 | $ErrorActionPreference = 'Stop'設定 | E-01 行60 | ○ |
| C-09 | Create-Directory関数の定義 | E-01 行71-73 | ○ |
| C-10 | Exec-Process関数の定義 | E-01 行83-110 | ○ |
| C-11 | InitializeDotNetCli関数の定義 | E-01 行155-228 | ○ |
| C-12 | Retry関数（5回リトライ、指数バックオフ） | E-01 行230-252 | ○ |
| C-13 | GetDotNetInstallScript関数の定義 | E-01 行254-281 | ○ |
| C-14 | InstallDotNet関数の定義 | E-01 行287-365 | ○ |
| C-15 | InitializeVisualStudioMSBuild関数の定義 | E-01 行378-477 | ○ |
| C-16 | vsMinVersionReqdStrは17.7 | E-01 行388 | ○ |
| C-17 | InitializeXCopyMSBuild関数の定義 | E-01 行494-520 | ○ |
| C-18 | LocateVisualStudio関数の定義 | E-01 行535-593 | ○ |
| C-19 | InitializeBuildTool関数の定義 | E-01 行595-639 | ○ |
| C-20 | GetNuGetPackageCachePath関数の定義 | E-01 行655-669 | ○ |
| C-21 | InitializeNativeTools関数の定義 | E-01 行676-690 | ○ |
| C-22 | InitializeToolset関数の定義 | E-01 行696-739 | ○ |
| C-23 | ExitWithExitCode関数の定義 | E-01 行741-746 | ○ |
| C-24 | MSBuild関数の定義 | E-01 行771-797 | ○ |
| C-25 | MSBuild-Core関数の定義 | E-01 行804-865 | ○ |
| C-26 | pipeline-logging-functions.ps1の読み込み | E-01 行907 | ○ |
| C-27 | RepoRoot、EngRoot等のパス変数設定 | E-01 行909-915 | ○ |
| C-28 | global.json読み込み | E-01 行916 | ○ |
| C-29 | configure-toolset.ps1の条件付き読み込み | E-01 行932-943 | ○ |
| C-30 | Enable-Nuget-EnhancedRetry関数の定義 | E-01 行948-960 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - dotnet/arcadeの中核スクリプトであり、広く使用されテストされている

## 6) レビュアーチェックリスト（最小）
- [ ] 主要関数の説明が正確か確認
- [ ] 変数のデフォルト値が正しく記載されているか確認
- [ ] pipeline-logging-functions.ps1との連携が正しく説明されているか確認
