---
generated_at: 2026-02-10 14:36:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-eng_common_tools.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/tools.sh` - スクリプト本体（行1-601）
- E-02: `eng/common/pipeline-logging-functions.sh` - パイプラインログ関数
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ciのデフォルトはfalse | E-01 行6 | ○ |
| C-02 | source_buildのデフォルトはfalse | E-01 行9 | ○ |
| C-03 | pipelines_logはCI時true | E-01 行15-19 | ○ |
| C-04 | configurationのデフォルトはDebug | E-01 行22 | ○ |
| C-05 | binary_logはCI時true | E-01 行27-34 | ○ |
| C-06 | node_reuseはCI時false | E-01 行46-50 | ○ |
| C-07 | warn_as_errorのデフォルトはtrue | E-01 行53 | ○ |
| C-08 | use_global_nuget_cacheはCI時false | E-01 行65-69 | ○ |
| C-09 | ResolvePath関数の定義 | E-01 行79-93 | ○ |
| C-10 | ReadGlobalVersion関数の定義 | E-01 行96-109 | ○ |
| C-11 | InitializeDotNetCli関数の定義 | E-01 行111-170 | ○ |
| C-12 | InstallDotNetSdk関数の定義 | E-01 行172-180 | ○ |
| C-13 | InstallDotNet関数の定義 | E-01 行182-271 | ○ |
| C-14 | with_retries関数（5回リトライ、指数バックオフ） | E-01 行273-293 | ○ |
| C-15 | GetDotNetInstallScript関数の定義 | E-01 行295-354 | ○ |
| C-16 | dotnet-install.shは30日経過で再ダウンロード | E-01 行304-314 | ○ |
| C-17 | InitializeBuildTool関数の定義 | E-01 行356-366 | ○ |
| C-18 | GetNuGetPackageCachePath関数の定義 | E-01 行368-379 | ○ |
| C-19 | InitializeNativeTools関数の定義 | E-01 行381-393 | ○ |
| C-20 | InitializeToolset関数の定義 | E-01 行395-440 | ○ |
| C-21 | ExitWithExitCode関数の定義 | E-01 行442-447 | ○ |
| C-22 | StopProcesses関数の定義 | E-01 行449-454 | ○ |
| C-23 | MSBuild関数の定義 | E-01 行456-481 | ○ |
| C-24 | MSBuild-Core関数の定義 | E-01 行483-526 | ○ |
| C-25 | GetDarc関数の定義 | E-01 行528-538 | ○ |
| C-26 | pipeline-logging-functions.shの読み込み | E-01 行549 | ○ |
| C-27 | global_json_has_runtimes判定（jq使用） | E-01 行562-569 | ○ |
| C-28 | configure-toolset.shの条件付き読み込み | E-01 行588-593 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - dotnet/arcadeの中核スクリプトであり、広く使用されテストされている

## 6) レビュアーチェックリスト（最小）
- [ ] 主要関数の説明が正確か確認
- [ ] 変数のデフォルト値が正しく記載されているか確認
- [ ] PowerShell版との機能対応が正しく説明されているか確認
