---
generated_at: 2026-02-10 14:38:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-eng_common_SetupNugetSources.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/SetupNugetSources.sh` - スクリプト本体（行1-197）
- E-02: `eng/common/tools.sh` - 依存ツールスクリプト
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | $1でConfigFile、$2でCredToken受け取り | E-01 行26-27 | ○ |
| C-02 | NL/TB変数の初期化 | E-01 行28-29 | ○ |
| C-03 | シンボリックリンク解決処理 | E-01 行31-41 | ○ |
| C-04 | tools.sh読み込み | E-01 行43 | ○ |
| C-05 | ConfigFile存在確認 | E-01 行45-48 | ○ |
| C-06 | macOS判定（uname -s == Darwin） | E-01 行50-53 | ○ |
| C-07 | EnableInternalPackageSource関数 | E-01 行56-78 | ○ |
| C-08 | AddPackageSource関数 | E-01 行81-99 | ○ |
| C-09 | AddOrEnablePackageSource関数 | E-01 行102-111 | ○ |
| C-10 | EnableMaestroInternalPackageSources関数 | E-01 行114-130 | ○ |
| C-11 | packageSourcesセクション確認 | E-01 行133-137 | ○ |
| C-12 | FeedSuffix設定（v2/v3切り替え） | E-01 行142-144 | ○ |
| C-13 | packageSourceCredentialsセクション作成 | E-01 行147-155 | ○ |
| C-14 | DotNetVersions配列（5,6,7,8,9,10） | E-01 行165 | ○ |
| C-15 | 内部フィード追加ループ | E-01 行167-174 | ○ |
| C-16 | darc-int-*フィード検出 | E-01 行177-181 | ○ |
| C-17 | 認証情報追加処理 | E-01 行183-195 | ○ |
| C-18 | sed -i.bakでバックアップ作成 | E-01 行70,97,154,193 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PowerShell版と同等の機能を提供する標準スクリプト

## 6) レビュアーチェックリスト（最小）
- [ ] macOS/Linux間のsed構文の違いが正しく説明されているか確認
- [ ] 対応するdotnetバージョンが正しく記載されているか確認
- [ ] 認証情報の設定方法が正しく説明されているか確認
