---
generated_at: 2026-02-10 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-eng/build.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/build.sh` - メインビルドスクリプト（408行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトconfigurationはDebug | E-01: `configuration="Debug"` (73行目) | ○ |
| C-02 | デフォルトソリューションはCompilers.slnf | E-01: `solution_to_build="Compilers.slnf"` (89行目) | ○ |
| C-03 | set -uで未定義変数エラー | E-01: `set -u` (7行目) | ○ |
| C-04 | set -eでサブコマンド失敗時に終了 | E-01: `set -e` (9行目) | ○ |
| C-05 | 引数なしで使用方法を表示して終了 | E-01: `if [[ $# = 0 ]]` (93-97行目) | ○ |
| C-06 | common/tools.shを読み込む | E-01: `. "$scriptroot/common/tools.sh"` (214行目) | ○ |
| C-07 | MakeBootstrapBuild関数でブートストラップ構築 | E-01: `function MakeBootstrapBuild` (216-240行目) | ○ |
| C-08 | BuildSolution関数でMSBuild実行 | E-01: `function BuildSolution` (242-339行目) | ○ |
| C-09 | ulimitでファイルディスクリプタ上限を6500に設定 | E-01: `ulimit -n 6500` (262行目) | ○ |
| C-10 | Monoテストにmono_pathを使用 | E-01: `mono_path=\`command -v mono\`` (285行目) | ○ |
| C-11 | --testIOperationで自動的にtestCoreClrも有効 | E-01: `test_core_clr=true` (268行目、test_ioperation時) | ○ |
| C-12 | --testRuntimeAsyncで自動的にtestCoreClrも有効 | E-01: `test_core_clr=true` (276行目、test_runtime_async時) | ○ |
| C-13 | --bootstrapで自動的にrestoreも有効 | E-01: `restore=true` (171行目) | ○ |
| C-14 | dotnet tool restoreを実行 | E-01: `dotnet tool restore` (370行目) | ○ |
| C-15 | テストにRunTests.dll(net10.0)を使用 | E-01: `artifacts/bin/RunTests/${configuration}/net10.0/RunTests.dll` (405行目) | ○ |
| C-16 | ExitWithExitCode 0で正常終了 | E-01: `ExitWithExitCode 0` (407行目) | ○ |
| C-17 | バイナリログはBuild.binlog | E-01: `bl="/bl:\"$log_dir/Build.binlog\""` (251行目) | ○ |
| C-18 | 本スクリプトはビルドカテゴリに属する | E-02: No.4のカテゴリ「ビルド」 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] 主要な入力パラメータがソースコードと一致するか確認済み
- [x] 処理フローがソースコードの実行順序と一致するか確認済み
- [x] エラー処理条件がソースコードと一致するか確認済み
- [ ] 実際の実行環境での動作確認（任意）
