---
generated_at: 2026-02-10 14:39:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-eng_common_init-tools-native.ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/init-tools-native.ps1` - スクリプト本体（行1-204）
- E-02: `eng/common/tools.ps1` - InitializeNativeTools関数からの呼び出し（行676-690）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | -BaseUriパラメータのデフォルト値 | E-01 行42 | ○ |
| C-02 | -InstallDirectoryパラメータ | E-01 行43 | ○ |
| C-03 | -Cleanパラメータ | E-01 行44 | ○ |
| C-04 | -Forceパラメータ | E-01 行45 | ○ |
| C-05 | -DownloadRetriesのデフォルト5 | E-01 行46 | ○ |
| C-06 | -RetryWaitTimeInSecondsのデフォルト30 | E-01 行47 | ○ |
| C-07 | -GlobalJsonFileパラメータ | E-01 行48 | ○ |
| C-08 | -PathPromotionパラメータ | E-01 行49 | ○ |
| C-09 | GlobalJsonFile自動決定 | E-01 行52-53 | ○ |
| C-10 | Set-StrictMode -Version 2.0 | E-01 行56 | ○ |
| C-11 | pipeline-logging-functions.ps1インポート | E-01 行59 | ○ |
| C-12 | CommonLibrary.psm1インポート | E-01 行60 | ○ |
| C-13 | Get-NativeInstallDirectory使用 | E-01 行68-69 | ○ |
| C-14 | native-tools解析 | E-01 行81-83 | ○ |
| C-15 | PathPromotion時arcade-tools確認 | E-01 行86-87 | ○ |
| C-16 | binpath.txt読み込み | E-01 行103-108 | ○ |
| C-17 | ##vso[task.prependpath]出力 | E-01 行111 | ○ |
| C-18 | install-tool.ps1呼び出し | E-01 行153 | ○ |
| C-19 | DoNotAbortNativeToolsInstallationOnFailure対応 | E-01 行156 | ○ |
| C-20 | Clean時の終了処理 | E-01 行185-187 | ○ |
| C-21 | InstallBin存在確認 | E-01 行188-195 | ○ |
| C-22 | tools.ps1からの呼び出し | E-02 行688 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ネイティブツールのインストールのみで、システムへの影響は限定的

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータのデフォルト値が正しく記載されているか確認
- [ ] PathPromotionモードの説明が正確か確認
- [ ] エラーハンドリングの説明が網羅的か確認
