---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：41-init-tools-native.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：具体的な数値根拠なし
  2. **エラーコードの種類**：スクリプトで明示的に定義されていない部分あり
  3. **jqフォールバック処理の詳細**：実装は確認できるが動作保証の根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/init-tools-native.sh`（メインスクリプト）
- E-02: `eng/common/tools.sh`（InitializeNativeTools関数）
- E-03: `eng/common/pipeline-logging-functions.sh`（ログ関数）
- E-04: `eng/common/native/common-library.sh`（共通ライブラリ）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | global.jsonのnative-toolsセクションを解析する | E-01 L78-162 | ○ |
| C-02 | デフォルトのベースURIはnetcorenativeassets.blob.core.windows.net | E-01 L6 | ○ |
| C-03 | ダウンロードリトライ回数のデフォルトは5回 | E-01 L10 | ○ |
| C-04 | リトライ待機時間のデフォルトは30秒 | E-01 L11 | ○ |
| C-05 | --cleanオプションでクリーンアップのみ実行 | E-01 L29-31, L193-195, L224-226 | ○ |
| C-06 | --forceオプションで再インストール | E-01 L33-35, L189-191 | ○ |
| C-07 | install-{ツール名}.shスクリプトを呼び出す | E-01 L182-183 | ○ |
| C-08 | tools.shのInitializeNativeTools関数から呼び出される | E-02 L381-393 | ○ |
| C-09 | jqコマンドが利用可能な場合はjqで解析 | E-01 L80-97 | ○ |
| C-10 | jq不在時はBash正規表現でフォールバック | E-01 L99-161 | ○ |
| C-11 | ##vso[task.prependpath]でPATH更新 | E-01 L230 | ○ |
| C-12 | Write-PipelineTelemetryErrorでエラー出力 | E-01 L202-206, L214-217 | ○ |
| C-13 | native-toolsセクションがない場合は正常終了 | E-01 L174-176 | ○ |
| C-14 | インストールディレクトリのデフォルトは$HOME/.netcoreeng/native | E-04（GetNativeInstallDirectory関数） | ○ |
| C-15 | --donotabortonfailureで失敗時も継続 | E-01 L200-207, L212-219 | ○ |
| C-16 | --donotdisplaywarningsで警告非表示 | E-01 L201, L213 | ○ |
| C-17 | 終了コード1でエラー終了 | E-01 L206, L218 | ○ |
| C-18 | 目標処理時間は1〜5分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の具体的な計測データや要件定義が存在しない
  - 候補：パフォーマンステスト結果 / CI実行ログ / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの主要機能は全てソースコードで確認可能
- 1: 中リスク - パフォーマンス要件は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] global.jsonのnative-toolsセクション解析ロジックが正確に記述されているか
- [ ] エラーハンドリングの記述がソースコードと一致しているか
- [ ] Azure Pipelinesとの連携（##vso出力）が正確に記述されているか
