---
generated_at: 2026-02-10 10:34:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-msbuild.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/msbuild.sh`（メインスクリプト）
- E-02: `eng/common/tools.sh`（MSBuild関数定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | verbosityのデフォルトは'minimal' | E-01 L15 | ○ |
| C-02 | warn_as_errorのデフォルトはtrue | E-01 L16 | ○ |
| C-03 | node_reuseのデフォルトはtrue | E-01 L17 | ○ |
| C-04 | CI環境でnode_reuseをfalseに設定 | E-01 L53-55 | ○ |
| C-05 | tools.shをソースで読み込み | E-01 L51 | ○ |
| C-06 | MSBuild関数にextra_argsを渡して呼び出し | E-01 L57 | ○ |
| C-07 | シンボリックリンク解決処理 | E-01 L3-13 | ○ |
| C-08 | 引数を小文字に変換して解析 | E-01 L22 | ○ |
| C-09 | --verbosityパラメータをサポート | E-01 L24-27 | ○ |
| C-10 | --warnaserrorパラメータをサポート | E-01 L28-31 | ○ |
| C-11 | --nodereuseパラメータをサポート | E-01 L32-35 | ○ |
| C-12 | --ciパラメータをサポート | E-01 L36-39 | ○ |
| C-13 | --preparemachineパラメータをサポート | E-01 L40-43 | ○ |
| C-14 | ExitWithExitCode 0で正常終了 | E-01 L58 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトがシンプルで全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータのデフォルト値がソースコードと一致しているか
- [ ] 引数解析ロジック（case文）が正確に記述されているか
- [ ] CI環境での動作（node_reuse無効化）が正確に記述されているか
