---
generated_at: 2026-02-10 10:36:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-sdk-task.ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/sdk-task.ps1`（メインスクリプト）
- E-02: `eng/common/tools.ps1`（GetSdkTaskProject関数等）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | configurationのデフォルトは'Debug' | E-01 L3 | ○ |
| C-02 | verbosityのデフォルトは'minimal' | E-01 L5 | ○ |
| C-03 | ciは$trueに固定 | E-01 L17 | ○ |
| C-04 | binaryLogはexcludeCIBinaryLogで制御 | E-01 L18 | ○ |
| C-05 | warnAsErrorはnoWarnAsErrorで制御 | E-01 L19 | ○ |
| C-06 | tools.ps1をドットソースで読み込み | E-01 L21 | ○ |
| C-07 | Print-Usage関数でヘルプ表示 | E-01 L23-37 | ○ |
| C-08 | -helpや/?でヘルプ表示して終了 | E-01 L55-59 | ○ |
| C-09 | -taskが空の場合エラー終了 | E-01 L61-65 | ○ |
| C-10 | msbuildEngine=vsでxcopy-msbuild初期化 | E-01 L67-83 | ○ |
| C-11 | GetSdkTaskProjectでプロジェクトパス取得 | E-01 L85 | ○ |
| C-12 | プロジェクト不存在でエラー終了 | E-01 L86-89 | ○ |
| C-13 | -restore指定時にBuild 'Restore'実行 | E-01 L91-93 | ○ |
| C-14 | Build 'Execute'でタスク実行 | E-01 L95 | ○ |
| C-15 | catchブロックでスタックトレース出力 | E-01 L98 | ○ |
| C-16 | Write-PipelineTelemetryErrorでエラー報告 | E-01 L99 | ○ |
| C-17 | エラー時ExitWithExitCode 1で終了 | E-01 L100 | ○ |
| C-18 | 成功時ExitWithExitCode 0で終了 | E-01 L103 | ○ |
| C-19 | バイナリログはlog_suffixで区別 | E-01 L40-41 | ○ |
| C-20 | Build関数でMSBuild呼び出し | E-01 L39-53 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] -taskパラメータが必須であることが明記されているか
- [ ] msbuildEngine=vsの場合のxcopy-msbuild初期化が正確に記述されているか
- [ ] RestoreとExecuteの実行順序が正確に記述されているか
