---
generated_at: 2026-02-10 10:38:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-sdk-task.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/sdk-task.sh`（メインスクリプト）
- E-02: `eng/common/tools.sh`（GetSdkTaskProject関数等）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | binary_logのデフォルトはtrue | E-01 L49 | ○ |
| C-02 | configurationのデフォルトは'Debug' | E-01 L50 | ○ |
| C-03 | verbosityのデフォルトは'minimal' | E-01 L51 | ○ |
| C-04 | show_usage関数でヘルプ表示 | E-01 L3-16 | ○ |
| C-05 | シンボリックリンク解決処理 | E-01 L18-28 | ○ |
| C-06 | Build関数でMSBuild呼び出し | E-01 L30-47 | ○ |
| C-07 | 引数を小文字に変換して解析 | E-01 L59 | ○ |
| C-08 | --taskパラメータをサポート | E-01 L61-64 | ○ |
| C-09 | --restoreパラメータをサポート | E-01 L65-68 | ○ |
| C-10 | --verbosityパラメータをサポート | E-01 L69-72 | ○ |
| C-11 | --excludecibinarylog/--noblをサポート | E-01 L73-77 | ○ |
| C-12 | --noWarnAsErrorをサポート（大文字小文字区別） | E-01 L78-80 | ○ |
| C-13 | ci=trueを設定 | E-01 L93 | ○ |
| C-14 | --helpでshow_usage実行して終了 | E-01 L95-98 | ○ |
| C-15 | tools.shをソースで読み込み | E-01 L100 | ○ |
| C-16 | InitializeToolsetを呼び出し | E-01 L101 | ○ |
| C-17 | --taskが空の場合エラー終了 | E-01 L103-106 | ○ |
| C-18 | GetSdkTaskProjectでプロジェクト取得 | E-01 L108 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] --taskパラメータが必須であることが明記されているか
- [ ] InitializeToolsetの呼び出しが正確に記述されているか
- [ ] RestoreとExecuteの実行順序が正確に記述されているか
