---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-darc-init.ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/darc-init.ps1`（メインスクリプト）
- E-02: `eng/common/tools.ps1`（InitializeDotNetCli関数、Get-Darc関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | darcVersionのデフォルトは$null | E-01 L2 | ○ |
| C-02 | versionEndpointのデフォルトはMaestro API URL | E-01 L3 | ○ |
| C-03 | verbosityのデフォルトは'minimal' | E-01 L4 | ○ |
| C-04 | toolpathのデフォルトは$null | E-01 L5 | ○ |
| C-05 | tools.ps1をドットソースで読み込み | E-01 L8 | ○ |
| C-06 | パッケージ名はmicrosoft.dotnet.darc | E-01 L11 | ○ |
| C-07 | InitializeDotNetCliでdotnetパス取得 | E-01 L13 | ○ |
| C-08 | dotnet tool list -gで既存インストール確認 | E-01 L15 | ○ |
| C-09 | 既存があればdotnet tool uninstall実行 | E-01 L17-19 | ○ |
| C-10 | バージョン未指定時はInvoke-WebRequestで取得 | E-01 L22-25 | ○ |
| C-11 | arcadeServicesSourceはAzure DevOpsフィード | E-01 L27 | ○ |
| C-12 | コマンドウィンドウ再起動の案内を出力 | E-01 L30 | ○ |
| C-13 | toolpath未指定時は-gオプションでインストール | E-01 L31-33 | ○ |
| C-14 | toolpath指定時は--tool-pathオプションでインストール | E-01 L34-37 | ○ |
| C-15 | catchブロックでスタックトレース出力 | E-01 L44 | ○ |
| C-16 | Write-PipelineTelemetryErrorでDarcカテゴリ出力 | E-01 L45 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Maestro APIエンドポイントが正確に記述されているか
- [ ] Azure DevOps NuGetフィードURLが正確に記述されているか
- [ ] グローバルインストールとtoolpathインストールの両方が記述されているか
