---
generated_at: 2026-02-10 10:42:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-darc-init.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/darc-init.sh`（メインスクリプト）
- E-02: `eng/common/tools.sh`（InitializeDotNetCli関数、GetDarc関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | darcVersionのデフォルトは空文字列 | E-01 L4 | ○ |
| C-02 | versionEndpointのデフォルトはMaestro API URL | E-01 L5 | ○ |
| C-03 | verbosityのデフォルトは'minimal' | E-01 L6 | ○ |
| C-04 | 引数を小文字に変換して解析 | E-01 L9 | ○ |
| C-05 | --darcversionパラメータをサポート | E-01 L11-14 | ○ |
| C-06 | --versionendpointパラメータをサポート | E-01 L15-18 | ○ |
| C-07 | --verbosityパラメータをサポート | E-01 L19-22 | ○ |
| C-08 | --toolpathパラメータをサポート | E-01 L23-26 | ○ |
| C-09 | 不明な引数でエラー終了 | E-01 L27-30 | ○ |
| C-10 | シンボリックリンク解決処理 | E-01 L37-45 | ○ |
| C-11 | tools.shをソースで読み込み | E-01 L47 | ○ |
| C-12 | バージョン未指定時はcurlで取得 | E-01 L49-51 | ○ |
| C-13 | パッケージ名はmicrosoft.dotnet.darc | E-01 L54 | ○ |
| C-14 | InitializeDotNetCliでdotnetパス取得 | E-01 L56-57 | ○ |
| C-15 | toolpath有無でtool listのオプション切り替え | E-01 L59-69 | ○ |
| C-16 | arcadeServicesSourceはAzure DevOpsフィード | E-01 L71 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Maestro APIエンドポイントが正確に記述されているか
- [ ] Azure DevOps NuGetフィードURLが正確に記述されているか
- [ ] 不明引数のエラーハンドリングが記述されているか
