---
generated_at: 2026-02-10 10:44:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-generate-sbom-prep.ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/generate-sbom-prep.ps1`（メインスクリプト）
- E-02: `eng/common/pipeline-logging-functions.ps1`（ログ関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManifestDirPathは必須パラメータ | E-01 L2 | ○ |
| C-02 | pipeline-logging-functions.ps1をドットソースで読み込み | E-01 L5 | ○ |
| C-03 | SYSTEM_STAGENAME_AGENT_JOBNAME_SBOMでアーティファクト名生成 | E-01 L9 | ○ |
| C-04 | 特殊文字を_に置換 | E-01 L10 | ○ |
| C-05 | ManifestDirPath配下にサブディレクトリを作成 | E-01 L11 | ○ |
| C-06 | 変換前後の名前をログ出力 | E-01 L13-14 | ○ |
| C-07 | Creating dirログ出力 | E-01 L16 | ○ |
| C-08 | Test-Pathでディレクトリ存在確認 | E-01 L19 | ○ |
| C-09 | New-Item -ItemType Directoryでディレクトリ作成 | E-01 L21 | ○ |
| C-10 | 成功時にSuccessfullyログ出力 | E-01 L22 | ○ |
| C-11 | ディレクトリ存在時にWrite-PipelineTelemetryError | E-01 L25 | ○ |
| C-12 | ##vso[task.setvariable]でARTIFACT_NAME設定 | E-01 L29 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 特殊文字の置換対象が正確に記述されているか
- [ ] 1ESテンプレートとの連携に関する説明が適切か
- [ ] Azure Pipelines変数設定コマンドが正確に記述されているか
