---
generated_at: 2026-02-10 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-eng/cibuild.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/cibuild.sh` - CIビルドスクリプト（19行）
- E-02: `eng/build.sh` - メインビルドスクリプト（408行）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | eng/build.shを呼び出す | E-01: `. "$scriptroot/build.sh"` (19行目) | ○ |
| C-02 | --ciオプションを付与 | E-01: `--ci` (19行目) | ○ |
| C-03 | --prepareMachineオプションを付与 | E-01: `--prepareMachine` (19行目) | ○ |
| C-04 | --restoreオプションを付与 | E-01: `--restore` (19行目) | ○ |
| C-05 | --buildオプションを付与 | E-01: `--build` (19行目) | ○ |
| C-06 | --bootstrapオプションを付与 | E-01: `--bootstrap` (19行目) | ○ |
| C-07 | --packオプションを付与 | E-01: `--pack` (19行目) | ○ |
| C-08 | --publishオプションを付与 | E-01: `--publish` (19行目) | ○ |
| C-09 | --binaryLogオプションを付与 | E-01: `--binaryLog` (19行目) | ○ |
| C-10 | git showでコミット情報を出力 | E-01: `git show --no-patch --pretty=raw HEAD` (17行目) | ○ |
| C-11 | シンボリックリンクを解決 | E-01: `while [[ -h $source ]]; do` (6-13行目) | ○ |
| C-12 | 本スクリプトはビルドカテゴリに属する | E-03: No.5のカテゴリ「ビルド」 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] cibuild.shのソースコードと設計書の記述が一致しているか確認済み
- [x] eng/build.shに渡されるオプションが正しく記述されているか確認済み
- [x] git showコマンドの実行が正しく記述されているか確認済み
- [ ] 実際のCI環境での動作確認（任意）
