---
generated_at: 2026-02-10 10:48:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-sdl.ps1

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/common/sdl/sdl.ps1`（メインスクリプト）
- E-02: `eng/common/tools.ps1`（共通関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Install-Gdn関数を定義 | E-01 L2-38 | ○ |
| C-02 | -Pathパラメータは必須 | E-01 L4-5 | ○ |
| C-03 | -Versionパラメータはオプション | E-01 L8 | ○ |
| C-04 | ErrorActionPreference = 'Stop' | E-01 L11 | ○ |
| C-05 | StrictMode Version 2.0 | E-01 L12 | ○ |
| C-06 | disableConfigureToolsetImport = $true | E-01 L13 | ○ |
| C-07 | ci = $true | E-01 L19 | ○ |
| C-08 | tools.ps1をドットソースで読み込み | E-01 L20 | ○ |
| C-09 | NuGet installコマンドでMicrosoft.Guardian.Cliをインストール | E-01 L22 | ○ |
| C-10 | NuGetフィードはsecuritytools.pkgs.visualstudio.com | E-01 L22 | ○ |
| C-11 | Version指定時に-Versionオプション追加 | E-01 L24-26 | ○ |
| C-12 | Start-Process -NoNewWindow -Wait | E-01 L28 | ○ |
| C-13 | Get-ChildItemで再帰的にguardian.cmd検索 | E-01 L30 | ○ |
| C-14 | 見つからない場合Write-PipelineTelemetryError (Sdlカテゴリ) | E-01 L32-35 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] NuGetフィードURLが正確に記述されているか
- [ ] Install-Gdn関数のパラメータ定義が正確に記述されているか
- [ ] エラー時のカテゴリ（Sdl）が正確に記述されているか
