---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：51-run-sdl.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値根拠なし
  2. **TSA連携詳細**：execute-all-sdl-tools.ps1に詳細があり本スクリプトでは不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/run-sdl.ps1`（ソースコード）
- E-02: `eng/common/tools.ps1`（依存スクリプト参照）
- E-03: `eng/common/sdl/execute-all-sdl-tools.ps1`（呼び出し元スクリプト）
- E-04: `eng/common/sdl/init-sdl.ps1`（前処理スクリプト）
- E-05: `eng/common/sdl/configure-sdl-tool.ps1`（設定スクリプト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Guardian CLIを使用してSDLセキュリティスキャンを実行する | E-01 L36-42 | ○ |
| C-02 | ErrorActionPreference='Stop'で初期化される | E-01 L9 | ○ |
| C-03 | tools.ps1を読み込む | E-01 L19 | ○ |
| C-04 | CI環境変数$ciをtrueに設定 | E-01 L18 | ○ |
| C-05 | .gdn/rディレクトリから設定ファイルを検索 | E-01 L22, L31 | ○ |
| C-06 | Guardian CLIパスをTest-Pathで検証 | E-01 L23-29 | ○ |
| C-07 | *.gdnconfigファイルを再帰的に検索 | E-01 L31 | ○ |
| C-08 | GuardianLoggerLevelのデフォルト値は'Standard' | E-01 L6 | ○ |
| C-09 | mainbaselineを使用してスキャン実行 | E-01 L38 | ○ |
| C-10 | UpdateBaselineパラメータでベースライン更新制御 | E-01 L39 | ○ |
| C-11 | execute-all-sdl-tools.ps1から呼び出される | E-03 L129-133 | ○ |
| C-12 | init-sdl.ps1の後に実行される | E-03 L78 | ○ |
| C-13 | configure-sdl-tool.ps1の後に実行される | E-03 L101, L121-124 | ○ |
| C-14 | エラー時にスタックトレースを出力 | E-01 L46 | ○ |
| C-15 | Write-PipelineTelemetryErrorでテレメトリ出力 | E-01 L27, L47 | ○ |
| C-16 | Exec-BlockVerboselyでコマンド実行 | E-01 L35-43 | ○ |
| C-17 | パフォーマンス要件はGuardian内部設定に依存 | **根拠なし** | △ |
| C-18 | TSA連携詳細 | **根拠なし（本スクリプト外）** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値：Guardian CLIの公式ドキュメントまたはベンチマーク情報が必要
  - 候補：Guardian CLI公式ドキュメント / Azure DevOps Security Integration Wiki / 実測データ
- TSA連携の詳細仕様：本スクリプトはrun機能のみ担当し、TSA公開はexecute-all-sdl-tools.ps1が担当
  - 候補：execute-all-sdl-tools.ps1のTsaPublish関連コード / TSA公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な処理フローはソースコードから明確に読み取れる
- 1: 中リスク - パフォーマンス要件は実環境での検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Guardian CLIのパス検証ロジックが実際の環境で正しく動作するか確認
- [ ] *.gdnconfig検索パスが想定通りか確認
- [ ] エラーハンドリングが運用要件を満たしているか確認
- [ ] ログ出力レベルが運用・デバッグに十分か確認
