---
generated_at: 2026-02-10 10:32:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：52-init-sdl.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **sdl-tool-cfg連携**：コード内にURI構築があるが実際には使用されていない可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/sdl/init-sdl.ps1`（ソースコード）
- E-02: `eng/common/tools.ps1`（依存スクリプト参照）
- E-03: `eng/common/sdl/execute-all-sdl-tools.ps1`（呼び出し元スクリプト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Guardian CLIのinitコマンドで作業環境を初期化 | E-01 L37 | ○ |
| C-02 | mainbaselineという名前でベースラインを作成 | E-01 L44 | ○ |
| C-03 | ErrorActionPreference='Stop'で初期化される | E-01 L10 | ○ |
| C-04 | tools.ps1を読み込む | E-01 L19 | ○ |
| C-05 | CI環境変数$ciをtrueに設定 | E-01 L18 | ○ |
| C-06 | ProgressPreferenceを'SilentlyContinue'に設定 | E-01 L22 | ○ |
| C-07 | Azure DevOps PATをBase64エンコード | E-01 L25 | ○ |
| C-08 | sdl-tool-cfgリポジトリへのURI構築 | E-01 L26-27 | ○ |
| C-09 | BranchNameのデフォルト値は'master' | E-01 L4 | ○ |
| C-10 | GuardianLoggerLevelのデフォルト値は'Standard' | E-01 L7 | ○ |
| C-11 | execute-all-sdl-tools.ps1から呼び出される | E-03 L78 | ○ |
| C-12 | init失敗時はLASTEXITCODEで終了 | E-01 L38-41 | ○ |
| C-13 | baseline失敗時はLASTEXITCODEで終了 | E-01 L45-48 | ○ |
| C-14 | エラー時にスタックトレースを出力 | E-01 L52 | ○ |
| C-15 | sdl-tool-cfgからの設定ダウンロード機能 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- sdl-tool-cfg連携の実際の動作：コード内にZIPダウンロード用のURI構築とSystem.IO.Compression.FileSystem参照があるが、現在の実装ではこの機能が使用されていない可能性がある
  - 候補：以前のバージョンのコード / 関連するAzure DevOpsパイプライン設定 / Guardian CLI公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理（init、baseline）はソースコードから明確に読み取れる
- 1: 中リスク - 未使用と思われるコードブロック（ZIPダウンロード関連）の目的要確認

## 6) レビュアーチェックリスト（最小）
- [ ] Guardian CLI initコマンドのオプションが正しいか確認
- [ ] mainbaselineの命名が他のスクリプト（run-sdl.ps1等）と整合しているか確認
- [ ] Azure DevOps PAT関連コードが実際に使用されているか確認
- [ ] エラーハンドリングが運用要件を満たしているか確認
